/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.chors.rest;

import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.ow2.choreos.chors.ChoreographyDeployer;
import org.ow2.choreos.chors.ChoreographyDeployerImpl;
import org.ow2.choreos.chors.ChoreographyNotFoundException;
import org.ow2.choreos.chors.EnactmentException;
import org.ow2.choreos.chors.datamodel.Choreography;
import org.ow2.choreos.chors.datamodel.ChoreographySpec;

@Path(value="chors")
public class ChorResource {
    private ChoreographyDeployer chorDeployer = new ChoreographyDeployerImpl();

    @POST
    @Consumes(value={"application/xml"})
    public Response create(ChoreographySpec chor, @Context UriInfo uriInfo) {
        if (chor == null || chor.getChoreographyServiceSpecs() == null || chor.getChoreographyServiceSpecs().isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        String chorId = this.chorDeployer.createChoreography(chor);
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder = uriBuilder.path(ChorResource.class).path(chorId);
        URI location = uriBuilder.build(new Object[0]);
        return Response.created((URI)location).build();
    }

    @GET
    @Path(value="{chorID}")
    @Produces(value={"application/xml"})
    public Response get(@PathParam(value="chorID") String chorId, @Context UriInfo uriInfo) {
        Choreography chor;
        if (chorId == null || chorId.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            chor = this.chorDeployer.getChoreography(chorId);
        }
        catch (ChoreographyNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder = uriBuilder.path(ChorResource.class).path(chorId);
        URI location = uriBuilder.build(new Object[0]);
        return Response.ok((Object)chor).location(location).build();
    }

    @POST
    @Path(value="{chorID}/enactment")
    @Produces(value={"application/xml"})
    public Response enact(@PathParam(value="chorID") String chorId, @Context UriInfo uriInfo) {
        Choreography chor;
        if (chorId == null || chorId.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder = uriBuilder.path(ChorResource.class).path(chorId);
        URI location = uriBuilder.build(new Object[0]);
        try {
            chor = this.chorDeployer.enactChoreography(chorId);
        }
        catch (EnactmentException e) {
            return Response.serverError().build();
        }
        catch (ChoreographyNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        System.out.println("At Resource: " + chor);
        return Response.ok((Object)chor).location(location).build();
    }

    @PUT
    @Path(value="{chorID}/update")
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml"})
    public Response update(@PathParam(value="chorID") String chorId, ChoreographySpec spec, @Context UriInfo uriInfo) {
        Choreography chor;
        if (chorId == null || chorId.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder = uriBuilder.path(ChorResource.class).path(chorId);
        URI location = uriBuilder.build(new Object[0]);
        try {
            this.chorDeployer.updateChoreography(chorId, spec);
            chor = this.chorDeployer.getChoreography(chorId);
        }
        catch (EnactmentException e) {
            return Response.serverError().build();
        }
        catch (ChoreographyNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)chor).location(location).build();
    }

    @PUT
    @Path(value="cleanup")
    @Produces(value={"application/xml"})
    public Response cleanUp(@Context UriInfo uriInfo) {
        return null;
    }
}

