/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.deployment;

import java.io.File;
import java.net.URL;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class Configuration {
    private final PropertiesConfiguration properties;
    private static Configuration INSTANCE = new Configuration();

    private PropertiesConfiguration getProperties() {
        return this.properties;
    }

    public static String get(String key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        String value = INSTANCE.getProperties().getString(key);
        if (value != null) {
            value.trim();
        }
        return value;
    }

    public static String[] getMultiple(String key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        String[] values = INSTANCE.getProperties().getStringArray(key);
        for (int i = 0; i < values.length; ++i) {
            values[i] = values[i].trim();
        }
        return values;
    }

    public static void set(String key, String value) {
        INSTANCE.getProperties().setProperty(key, (Object)value);
    }

    public static void set(String key, String[] values) {
        INSTANCE.getProperties().setProperty(key, (Object)values);
    }

    private Configuration() {
        PropertiesConfiguration tmp = null;
        try {
            URL fileUrl = this.getClass().getClassLoader().getResource("deployment.properties");
            if (fileUrl != null) {
                File propertiesFile = new File(fileUrl.getFile());
                tmp = new PropertiesConfiguration(propertiesFile);
            } else {
                tmp = new PropertiesConfiguration();
            }
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
            tmp = new PropertiesConfiguration();
        }
        this.properties = tmp;
    }
}

