/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.deployment.nodes.cloudprovider;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.cxf.common.util.StringUtils;
import org.apache.log4j.Logger;
import org.jclouds.aws.ec2.compute.AWSEC2ComputeService;
import org.jclouds.aws.ec2.compute.AWSEC2TemplateOptions;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.ComputeServiceContextFactory;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.ow2.choreos.deployment.Configuration;
import org.ow2.choreos.deployment.nodes.cloudprovider.CloudProvider;
import org.ow2.choreos.deployment.nodes.cloudprovider.NodeRegistry;
import org.ow2.choreos.nodes.NodeNotFoundException;
import org.ow2.choreos.nodes.datamodel.Node;
import org.ow2.choreos.services.datamodel.ResourceImpact;

public class AWSCloudProvider
implements CloudProvider {
    private Logger logger = Logger.getLogger(AWSCloudProvider.class);
    private static String DEFAULT_USER = "ubuntu";
    private static String PROVIDER = "aws-ec2";
    private static String DEFAULT_IMAGE = "us-east-1/ami-3b4ff252";
    private NodeRegistry registry = NodeRegistry.getInstance();

    @Override
    public String getProviderName() {
        return PROVIDER;
    }

    ComputeService getClient(String image) {
        Properties overrides = new Properties();
        overrides.setProperty("jclouds.ec2.ami-query", "image-id=" + image);
        ComputeServiceContext context = new ComputeServiceContextFactory().createContext(PROVIDER, Configuration.get("AMAZON_ACCESS_KEY_ID"), Configuration.get("AMAZON_SECRET_KEY"), (Iterable)ImmutableSet.of(), overrides);
        return context.getComputeService();
    }

    @Override
    public Node createNode(Node node, ResourceImpact resourceImpact) throws RunNodesException {
        long t0 = System.currentTimeMillis();
        this.logger.debug((Object)"Creating node...");
        String imageId = node.getImage();
        if (StringUtils.isEmpty((String)imageId)) {
            imageId = DEFAULT_IMAGE;
        }
        String image = imageId.substring(imageId.indexOf(47) + 1);
        ComputeService client = this.getClient(image);
        Set createdNodes = client.createNodesInGroup("default", 1, this.getTemplate(client, imageId, resourceImpact));
        NodeMetadata cloudNode = (NodeMetadata)Iterables.get((Iterable)createdNodes, (int)0);
        this.setNodeProperties(node, cloudNode);
        client.getContext().close();
        long tf = System.currentTimeMillis();
        long duration = tf - t0;
        this.logger.debug((Object)(node + " created in " + duration + " miliseconds"));
        this.registry.putNode(node);
        return node;
    }

    @Override
    public Node getNode(String nodeId) throws NodeNotFoundException {
        Node node = this.registry.getNode(nodeId);
        if (node == null) {
            throw new NodeNotFoundException("Node " + nodeId + " not found");
        }
        return node;
    }

    @Override
    public List<Node> getNodes() {
        List<Node> nodes = this.registry.getNodes();
        if (nodes.isEmpty()) {
            nodes = this.fillRegistry();
        }
        return nodes;
    }

    private List<Node> fillRegistry() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Node node : this.getNodesWithoutCache()) {
            this.registry.putNode(node);
            nodes.add(node);
        }
        return nodes;
    }

    public List<Node> getNodesWithoutCache() {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        ComputeService client = this.getClient("");
        Set cloudNodes = client.listNodes();
        for (ComputeMetadata computeMetadata : cloudNodes) {
            NodeMetadata cloudNode = client.getNodeMetadata(computeMetadata.getId());
            Node node = new Node();
            this.setNodeProperties(node, cloudNode);
            if (node.getState() == 1) continue;
            nodeList.add(node);
        }
        client.getContext().close();
        return nodeList;
    }

    @Override
    public void destroyNode(String id) {
        ComputeService client = this.getClient("");
        client.destroyNode(id);
        client.getContext().close();
        this.registry.deleteNode(id);
    }

    private void setNodeProperties(Node node, NodeMetadata cloudNode) {
        this.setNodeIp(node, cloudNode);
        node.setHostname(cloudNode.getName());
        node.setSo(cloudNode.getOperatingSystem().getName());
        node.setId(cloudNode.getId());
        node.setImage(cloudNode.getImageId());
        node.setState(Integer.valueOf(cloudNode.getState().ordinal()));
        node.setUser(DEFAULT_USER);
        node.setPrivateKey(Configuration.get("AMAZON_PRIVATE_SSH_KEY"));
    }

    private void setNodeIp(Node node, NodeMetadata cloudNode) {
        Iterator publicAddresses = cloudNode.getPublicAddresses().iterator();
        if (publicAddresses != null && publicAddresses.hasNext()) {
            node.setIp((String)publicAddresses.next());
        }
    }

    private Template getTemplate(ComputeService client, String imageId, ResourceImpact resourceImpact) {
        String AWSInstanceType = this.getInstanceTypeFromResourceImpact(resourceImpact);
        TemplateBuilder builder = client.templateBuilder().imageId(imageId);
        if (client instanceof AWSEC2ComputeService) {
            builder.hardwareId(AWSInstanceType);
            Template template = builder.build();
            AWSEC2TemplateOptions options = (AWSEC2TemplateOptions)template.getOptions().as(AWSEC2TemplateOptions.class);
            options.securityGroups(new String[]{"default"});
            options.keyPair(Configuration.get("AMAZON_KEY_PAIR"));
            return template;
        }
        return builder.build();
    }

    private String getInstanceTypeFromResourceImpact(ResourceImpact resourceImpact) {
        String defaultImage = "m1.small";
        if (resourceImpact != null && resourceImpact.getMemory() != null) {
            switch (resourceImpact.getMemory()) {
                case SMALL: {
                    return "m1.small";
                }
                case MEDIUM: {
                    return "m1.medium";
                }
                case LARGE: {
                    return "m1.large";
                }
            }
            return defaultImage;
        }
        return defaultImage;
    }

    @Override
    public Node createOrUseExistingNode(Node node, ResourceImpact resourceImpact) throws RunNodesException {
        List<Node> nodes = this.getNodes();
        if (nodes.size() > 0) {
            return nodes.get(0);
        }
        return this.createNode(node, resourceImpact);
    }
}

