/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.deployment.nodes.cloudprovider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jclouds.compute.RunNodesException;
import org.ow2.choreos.deployment.Configuration;
import org.ow2.choreos.deployment.nodes.cloudprovider.CloudProvider;
import org.ow2.choreos.nodes.NodeNotFoundException;
import org.ow2.choreos.nodes.datamodel.Node;
import org.ow2.choreos.services.datamodel.ResourceImpact;

public class FixedCloudProvider
implements CloudProvider {
    private Map<String, Node> nodes = new HashMap<String, Node>();

    public FixedCloudProvider() {
        String[] ips = Configuration.getMultiple("FIXED_VM_IPS");
        String[] hosts = Configuration.getMultiple("FIXED_VM_HOSTNAMES");
        String[] users = Configuration.getMultiple("FIXED_VM_USERS");
        String[] keys = Configuration.getMultiple("FIXED_VM_PRIVATE_SSH_KEYS");
        String[] types = Configuration.getMultiple("FIXED_VM_TYPES");
        if (ips.length == hosts.length && ips.length == users.length && ips.length == keys.length && types.length == ips.length) {
            int node_id = 0;
            int i = 0;
            while (i < ips.length) {
                Node node = new Node();
                String id = this.setNode(ips[i], hosts[i], users[i], keys[i], types[i], node, node_id);
                this.addNode(node, id);
                ++i;
                ++node_id;
            }
        }
    }

    private void addNode(Node node, String id) {
        this.nodes.put(id, node);
    }

    private String setNode(String ip, String host, String user, String key, String type, Node node, int id) {
        node.setIp(ip);
        node.setHostname(host);
        node.setChefName(host);
        node.setUser(user);
        node.setPrivateKey(key);
        node.setId(Integer.toString(id));
        node.setCpus(Integer.valueOf(1));
        node.setRam(Integer.valueOf(this.memFromType(type)));
        node.setSo("Ubuntu server 10.04");
        node.setStorage(Integer.valueOf(10000));
        node.setZone("BR");
        return node.getId();
    }

    private int memFromType(String type) {
        if (type.compareTo("SMALL") == 0) {
            return 256;
        }
        if (type.compareTo("MEDIUM") == 0) {
            return 512;
        }
        if (type.compareTo("LARGE") == 0) {
            return 768;
        }
        return 256;
    }

    @Override
    public Node getNode(String nodeId) throws NodeNotFoundException {
        if (this.nodes.containsKey(nodeId)) {
            return this.nodes.get(nodeId);
        }
        throw new NodeNotFoundException(nodeId);
    }

    @Override
    public List<Node> getNodes() {
        ArrayList<Node> theList = new ArrayList<Node>();
        theList.addAll(this.nodes.values());
        return theList;
    }

    @Override
    public Node createOrUseExistingNode(Node node, ResourceImpact resourceImpact) throws RunNodesException {
        if (node != null) {
            return this.nodes.containsKey(node.getId()) ? this.nodes.get(node.getId()) : this.createNode(node, resourceImpact);
        }
        if (!this.nodes.keySet().isEmpty()) {
            Iterator<String> it = this.nodes.keySet().iterator();
            return this.nodes.get(it.next());
        }
        throw new IllegalStateException("FixedCloudProvider does not creates nodes and there is no node available in the moment.");
    }

    @Override
    public String getProviderName() {
        return "Fixed Provider";
    }

    @Override
    public void destroyNode(String id) {
        throw new UnsupportedOperationException("FixedCloudProvider does not destroy nodes");
    }

    @Override
    public Node createNode(Node node, ResourceImpact resourceImpact) throws RunNodesException {
        throw new UnsupportedOperationException("FixedCloudProvider cannot create new nodes");
    }
}

