/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.deployment.nodes.cloudprovider;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jclouds.ContextBuilder;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.openstack.nova.v2_0.compute.options.NovaTemplateOptions;
import org.jclouds.rest.AuthorizationException;
import org.ow2.choreos.deployment.Configuration;
import org.ow2.choreos.deployment.nodes.cloudprovider.CloudProvider;
import org.ow2.choreos.nodes.NodeNotFoundException;
import org.ow2.choreos.nodes.datamodel.Node;
import org.ow2.choreos.services.datamodel.ResourceImpact;

public class OpenStackKeystoneCloudProvider
implements CloudProvider {
    private static String OP_AUTHURL = Configuration.get("OPENSTACK_IP");
    private static String OP_TENANT = Configuration.get("OPENSTACK_TENANT");
    private static String OP_USER = Configuration.get("OPENSTACK_USER");
    private static String OP_PASS = Configuration.get("OPENSTACK_PASSWORD");

    @Override
    public String getProviderName() {
        return "OpenStack Keystone Provider";
    }

    private ComputeService getClient(String imageId) {
        System.out.println(">OpenStack: Obtain Client.");
        String provider = "openstack-nova";
        String identity = OP_TENANT + ":" + OP_USER;
        String credential = OP_PASS;
        Properties properties = new Properties();
        properties.setProperty("jclouds.endpoint", OP_AUTHURL);
        ImmutableSet modules = ImmutableSet.of();
        ContextBuilder builder = ContextBuilder.newBuilder((String)provider).credentials(identity, credential).modules((Iterable)modules).overrides(properties);
        System.out.printf(">OpenStack: Initializing Client With Data: \n\t> %s%n", builder.getApiMetadata());
        ComputeService srv = ((ComputeServiceContext)builder.buildView(ComputeServiceContext.class)).getComputeService();
        System.out.println(">OpenStack: Client obtained successfully.");
        return srv;
    }

    @Override
    public Node createNode(Node node, ResourceImpact resourceImpact) throws RunNodesException {
        Set createdNodes;
        System.out.println(">OpenStack: Create new Node.");
        ComputeService client = this.getClient("");
        try {
            createdNodes = client.createNodesInGroup("default", 1, this.getTemplate(client, this.getImages().get(0).getId()));
        }
        catch (AuthorizationException e) {
            System.out.println(">OpenStack: Authorization failed. Provided user doesn't have authorization to create a new node.");
            throw e;
        }
        NodeMetadata cloudNode = (NodeMetadata)Iterables.get((Iterable)createdNodes, (int)0);
        this.setNodeProperties(node, cloudNode);
        client.getContext().close();
        System.out.println(">OpenStack: Node created successfully.");
        return node;
    }

    @Override
    public Node getNode(String nodeId) throws NodeNotFoundException {
        ComputeService client = this.getClient("");
        Node node = new Node();
        try {
            NodeMetadata cloudNode = client.getNodeMetadata(nodeId);
            this.setNodeProperties(node, cloudNode);
        }
        catch (Exception e) {
            throw new NodeNotFoundException(nodeId);
        }
        return node;
    }

    @Override
    public List<Node> getNodes() {
        System.out.println(">OpenStack: List Nodes.");
        ArrayList<Node> nodeList = new ArrayList<Node>();
        ComputeService client = this.getClient("");
        Set cloudNodes = client.listNodes();
        for (ComputeMetadata computeMetadata : cloudNodes) {
            NodeMetadata cloudNode = client.getNodeMetadata(computeMetadata.getId());
            Node node = new Node();
            this.setNodeProperties(node, cloudNode);
            if (node.getState() == 1) continue;
            nodeList.add(node);
        }
        client.getContext().close();
        System.out.println(">OpenStack: Node List obtained successfully.");
        return nodeList;
    }

    public List<Image> getImages() {
        System.out.println(">OpenStack: List Images.");
        ComputeService client = this.getClient("");
        Set images = client.listImages();
        ArrayList<Image> imageList = new ArrayList<Image>();
        for (Image image : images) {
            imageList.add(image);
        }
        System.out.println(">OpenStack: Image List obtained successfully.");
        return imageList;
    }

    public List<Hardware> getHardwareProfiles() {
        System.out.println(">OpenStack: List Hardware Profiles.");
        ComputeService client = this.getClient("");
        Set profiles = client.listHardwareProfiles();
        ArrayList<Hardware> hardwareList = new ArrayList<Hardware>();
        for (Hardware profile : profiles) {
            hardwareList.add(profile);
        }
        System.out.println(">OpenStack: Hardware Profiles obtained successfully.");
        return hardwareList;
    }

    @Override
    public void destroyNode(String id) {
        System.out.println(">OpenStack: Destroy Node.");
        ComputeService client = this.getClient("");
        client.destroyNode(id);
        client.getContext().close();
        System.out.println(">OpenStack: Node destroyed successfully.");
    }

    @Override
    public Node createOrUseExistingNode(Node node, ResourceImpact resourceImpact) throws RunNodesException {
        for (Node n : this.getNodes()) {
            if (!n.getImage().equals(node.getImage()) || NodeState.RUNNING.ordinal() != n.getState().intValue()) continue;
            return n;
        }
        return this.createNode(node, resourceImpact);
    }

    private Template getTemplate(ComputeService client, String imageId) {
        if (imageId.isEmpty()) {
            imageId = this.getImages().get(0).getId();
        }
        String hardwareId = this.getHardwareProfiles().get(0).getId();
        System.out.println("\tCreating Template with:");
        System.out.println("\tImage ID: " + imageId);
        System.out.println("\tHardware ID: " + hardwareId);
        TemplateBuilder builder = client.templateBuilder().imageId(imageId);
        builder.hardwareId(hardwareId);
        System.out.println("\tBuilding Template...");
        Template template = builder.build();
        NovaTemplateOptions options = (NovaTemplateOptions)template.getOptions().as(NovaTemplateOptions.class);
        options.keyPairName(Configuration.get("OPENSTACK_KEY_PAIR"));
        System.out.println("\tTemplate built successfully!");
        return template;
    }

    private void setNodeProperties(Node node, NodeMetadata cloudNode) {
        this.setNodeIp(node, cloudNode);
        node.setHostname(cloudNode.getName());
        node.setSo(cloudNode.getOperatingSystem().getName());
        node.setId(cloudNode.getId());
        node.setImage(cloudNode.getImageId());
        node.setState(Integer.valueOf(cloudNode.getState().ordinal()));
        node.setUser("ubuntu");
        node.setPrivateKeyFile(Configuration.get("OPENSTACK_PRIVATE_SSH_KEY"));
    }

    private void setNodeIp(Node node, NodeMetadata cloudNode) {
        Iterator publicAddresses = cloudNode.getPrivateAddresses().iterator();
        if (publicAddresses != null && publicAddresses.hasNext()) {
            node.setIp((String)publicAddresses.next());
        }
    }
}

