/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.deployment.nodes.cm;

import com.jcraft.jsch.JSchException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.ow2.choreos.deployment.Configuration;
import org.ow2.choreos.nodes.NodeNotUpgradedException;
import org.ow2.choreos.nodes.datamodel.Node;
import org.ow2.choreos.utils.SshCommandFailed;
import org.ow2.choreos.utils.SshUtil;

public class NodeUpgrader {
    private Logger logger = Logger.getLogger(NodeUpgrader.class);
    private static ConcurrentMap<Node, Boolean> updating = new ConcurrentHashMap<Node, Boolean>();
    private static ConcurrentMap<Node, Boolean> needUpdate = new ConcurrentHashMap<Node, Boolean>();

    public void upgradeNodeConfiguration(Node node) throws JSchException, NodeNotUpgradedException {
        needUpdate.put(node, true);
        if (updating.containsKey(node) && ((Boolean)updating.get(node)).booleanValue()) {
            while (((Boolean)updating.get(node)).booleanValue()) {
                this.sleep(10000L);
            }
            return;
        }
        SshUtil ssh = new SshUtil(node.getIp(), node.getUser(), node.getPrivateKeyFile());
        while (((Boolean)needUpdate.get(node)).booleanValue()) {
            needUpdate.put(node, false);
            updating.put(node, true);
            this.logger.debug((Object)("upgrading node " + node));
            try {
                this.runChefClient(ssh);
            }
            catch (SshCommandFailed e) {
                needUpdate.remove(node);
                updating.remove(node);
                String message = "chef-client returned an error exit status on node " + node.toString();
                this.logger.error((Object)message);
                throw new NodeNotUpgradedException(node.getId(), message);
            }
            updating.put(node, false);
        }
    }

    private void runChefClient(SshUtil ssh) throws JSchException, SshCommandFailed {
        String logFile = Configuration.get("CHEF_CLIENT_LOG");
        if (logFile == null || logFile.isEmpty()) {
            logFile = "/tmp/chef-client.log";
        }
        String CHEF_CLIENT_COMMAND = "sudo chef-client --logfile " + logFile;
        int MAX_TRIALS = 5;
        int SLEEPING_TIME = 5000;
        int trials = 0;
        boolean ok = false;
        while (!ok) {
            try {
                ++trials;
                ssh.runCommand(CHEF_CLIENT_COMMAND);
                ok = true;
            }
            catch (JSchException e) {
                if (trials >= 5) {
                    throw e;
                }
                this.sleep(5000L);
            }
            catch (SshCommandFailed e) {
                if (trials >= 5) {
                    throw e;
                }
                this.sleep(5000L);
            }
        }
    }

    private void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e1) {
            this.logger.error((Object)"Exception at sleeping, should not happen");
        }
    }
}

