/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.deployment.nodes.rest;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;
import org.ow2.choreos.deployment.Configuration;
import org.ow2.choreos.deployment.nodes.NPMImpl;
import org.ow2.choreos.deployment.nodes.cloudprovider.CloudProviderFactory;
import org.ow2.choreos.deployment.nodes.rest.NodesResource;
import org.ow2.choreos.nodes.ConfigNotAppliedException;
import org.ow2.choreos.nodes.NodePoolManager;
import org.ow2.choreos.nodes.datamodel.Config;
import org.ow2.choreos.nodes.datamodel.Node;
import org.ow2.choreos.nodes.datamodel.NodeRestRepresentation;

@Path(value="nodes/configs")
public class ConfigsResource {
    private Logger logger = Logger.getLogger(ConfigsResource.class);
    private String cloudProviderType = Configuration.get("CLOUD_PROVIDER");
    private NodePoolManager npm = new NPMImpl(CloudProviderFactory.getInstance(this.cloudProviderType));

    @POST
    @Consumes(value={"application/xml"})
    public Response applyConfig(Config config, @Context UriInfo uriInfo) throws URISyntaxException {
        List nodes;
        this.logger.debug((Object)("Request to apply " + config.getName()));
        if (config == null || config.getName() == null || config.getName().isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            nodes = this.npm.applyConfig(config);
        }
        catch (ConfigNotAppliedException e) {
            this.logger.error((Object)"Config not applied", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        Node node = (Node)nodes.get(0);
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder = uriBuilder.path(NodesResource.class).path(node.getId());
        URI uri = uriBuilder.build(new Object[0]);
        NodeRestRepresentation nodeRest = new NodeRestRepresentation(node);
        return Response.created((URI)uri).entity((Object)nodeRest).build();
    }
}

