/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.deployment.nodes.rest;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;
import org.ow2.choreos.deployment.Configuration;
import org.ow2.choreos.deployment.nodes.NPMImpl;
import org.ow2.choreos.deployment.nodes.cloudprovider.CloudProviderFactory;
import org.ow2.choreos.nodes.NodeNotCreatedException;
import org.ow2.choreos.nodes.NodeNotDestroyed;
import org.ow2.choreos.nodes.NodeNotFoundException;
import org.ow2.choreos.nodes.NodeNotUpgradedException;
import org.ow2.choreos.nodes.NodePoolManager;
import org.ow2.choreos.nodes.datamodel.Node;
import org.ow2.choreos.nodes.datamodel.NodeCreationRequestSpec;
import org.ow2.choreos.nodes.datamodel.NodeRestRepresentation;
import org.ow2.choreos.services.datamodel.ResourceImpact;

@Path(value="nodes")
public class NodesResource {
    private Logger logger = Logger.getLogger(NodesResource.class);
    private String cloudProviderType = Configuration.get("CLOUD_PROVIDER");
    private NodePoolManager npm = new NPMImpl(CloudProviderFactory.getInstance(this.cloudProviderType));

    @POST
    @Consumes(value={"application/xml"})
    public Response createNode(NodeCreationRequestSpec requestSpec, @Context UriInfo uriInfo) throws URISyntaxException {
        this.logger.debug((Object)"Request to create node");
        Node node = requestSpec.getNode();
        ResourceImpact resourceImpact = requestSpec.getResourceImpact();
        try {
            this.npm.createNode(node, resourceImpact);
        }
        catch (NodeNotCreatedException e) {
            this.logger.warn((Object)"Node not created", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        this.logger.info((Object)(node + " created"));
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder = uriBuilder.path(NodesResource.class).path(node.getId());
        URI uri = uriBuilder.build(new Object[0]);
        NodeRestRepresentation nodeRest = new NodeRestRepresentation(node);
        return Response.created((URI)uri).entity((Object)nodeRest).build();
    }

    @GET
    public List<NodeRestRepresentation> getNodes() {
        this.logger.debug((Object)"Request to get nodes");
        ArrayList<NodeRestRepresentation> restNodeList = new ArrayList<NodeRestRepresentation>();
        for (Node node : this.npm.getNodes()) {
            restNodeList.add(node.getRestRepresentation());
        }
        return restNodeList;
    }

    @GET
    @Path(value="{node_id:.+}")
    public Response getNode(@PathParam(value="node_id") String nodeId) {
        Response response;
        this.logger.debug((Object)("Request to get node " + nodeId));
        try {
            Node node = this.npm.getNode(nodeId);
            NodeRestRepresentation nodeRest = new NodeRestRepresentation(node);
            response = Response.ok((Object)nodeRest).build();
        }
        catch (NodeNotFoundException e) {
            this.logger.error((Object)"Node not found", (Throwable)e);
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return response;
    }

    @DELETE
    @Path(value="{node_id:.+}")
    public Response deleteNode(@PathParam(value="node_id") String id) {
        Response response;
        this.logger.debug((Object)"Request to delete node");
        try {
            this.npm.destroyNode(id);
            response = Response.status((Response.Status)Response.Status.OK).build();
            this.logger.info((Object)("Node " + id + " deleted"));
        }
        catch (NodeNotDestroyed e) {
            this.logger.error((Object)"Nodes not destroyed", (Throwable)e);
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (NodeNotFoundException e) {
            this.logger.error((Object)"Nodes not destroyed", (Throwable)e);
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return response;
    }

    @DELETE
    public Response deleteNodes() {
        Response response;
        this.logger.debug((Object)"Request to delete all the nodes");
        try {
            this.npm.destroyNodes();
            response = Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (NodeNotDestroyed e) {
            this.logger.error((Object)"Nodes not destroyed", (Throwable)e);
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return response;
    }

    @POST
    @Path(value="{node_id:.+}/upgrade")
    public Response upgradeNode(@PathParam(value="node_id") String nodeId) {
        Response response;
        this.logger.debug((Object)("Request to upgrade node " + nodeId));
        try {
            this.npm.upgradeNode(nodeId);
            this.logger.info((Object)("Node " + nodeId + " upgraded"));
            response = Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (NodeNotUpgradedException e) {
            this.logger.error((Object)("Node " + nodeId + " not upgraded"), (Throwable)e);
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (NodeNotFoundException e) {
            this.logger.error((Object)("Node " + nodeId + " not upgraded"), (Throwable)e);
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return response;
    }
}

