/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.deployment.nodes.selector;

import java.util.ArrayList;
import java.util.List;
import org.ow2.choreos.deployment.Configuration;
import org.ow2.choreos.deployment.nodes.selector.NodeSelectorMapperPolicy;
import org.ow2.choreos.nodes.datamodel.Node;
import org.ow2.choreos.services.datamodel.ResourceImpact;
import org.ow2.choreos.services.datamodel.ResourceImpactDefs;

public class NodeSelectorMapper {
    private static final String[] NODE_TYPES = Configuration.getMultiple("NODE_TYPES");
    private NodeSelectorMapperPolicy policy = null;

    public NodeSelectorMapper(String policy) {
        if (policy.compareTo("ANY_FIT") == 0) {
            this.policy = NodeSelectorMapperPolicy.ANY_FIT;
        } else if (policy.compareTo("EXACT_FIT") == 0) {
            this.policy = NodeSelectorMapperPolicy.EXACT_FIT;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static String[] types() {
        return NODE_TYPES;
    }

    public List<Node> filterByResourceImpact(ResourceImpact resourceImpact, List<Node> allNodes) {
        ArrayList<Node> filtered = new ArrayList<Node>();
        for (Node node : allNodes) {
            if (!this.isAcceptable(resourceImpact, node)) continue;
            filtered.add(node);
        }
        return filtered;
    }

    private boolean near(int a, int b) {
        return (double)Math.abs(a - b) < 0.1 * (double)a;
    }

    private int getBaseMemoryFromType(ResourceImpactDefs.MemoryTypes memory) {
        switch (memory) {
            case SMALL: {
                return 256;
            }
            case MEDIUM: {
                return 512;
            }
            case LARGE: {
                return 768;
            }
        }
        return 256;
    }

    public boolean isAcceptable(ResourceImpact resourceImpact, Node selected) {
        if (resourceImpact == null || resourceImpact.getMemory() == null) {
            return true;
        }
        switch (this.policy) {
            case ANY_FIT: {
                return this.getBaseMemoryFromType(resourceImpact.getMemory()) <= selected.getRam();
            }
            case EXACT_FIT: {
                return this.near(this.getBaseMemoryFromType(resourceImpact.getMemory()), selected.getRam());
            }
        }
        return false;
    }
}

