/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.deployment.nodes.selector;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.ow2.choreos.deployment.Configuration;
import org.ow2.choreos.deployment.nodes.cloudprovider.CloudProvider;
import org.ow2.choreos.deployment.nodes.selector.NodeSelector;
import org.ow2.choreos.deployment.nodes.selector.NodeSelectorMapper;
import org.ow2.choreos.nodes.datamodel.Config;
import org.ow2.choreos.nodes.datamodel.Node;

public class RoundRobinSelector
implements NodeSelector {
    private Logger logger = Logger.getLogger(RoundRobinSelector.class);
    private NodeSelectorMapper mapper = new NodeSelectorMapper(Configuration.get("MAPPER_POLICY"));
    private AtomicInteger counter = new AtomicInteger();
    private CloudProvider cloudProvider;

    public RoundRobinSelector(CloudProvider cloudProvider) {
        this.cloudProvider = cloudProvider;
    }

    @Override
    public List<Node> selectNodes(Config config) {
        int numberOfInstances = config.getNumberOfInstances();
        List<Node> allNodes = this.cloudProvider.getNodes();
        List<Node> compatibleNodes = this.mapper.filterByResourceImpact(config.getResourceImpact(), allNodes);
        if (compatibleNodes.size() < numberOfInstances) {
            String message = "Not enough nodes (available: " + compatibleNodes.size() + ") to deploy requested number of instances (requested: " + numberOfInstances + ")";
            this.logger.error((Object)message);
            return new ArrayList<Node>();
        }
        ArrayList<Node> resultList = new ArrayList<Node>();
        int i = 0;
        for (int j = 0; i < numberOfInstances && j < allNodes.size(); ++j) {
            int idx = this.counter.getAndIncrement();
            Node selected = allNodes.get(idx %= allNodes.size());
            if (!this.mapper.isAcceptable(config.getResourceImpact(), selected)) continue;
            this.logger.debug((Object)("Selector has chosen " + selected));
            resultList.add(selected);
            ++i;
        }
        return resultList;
    }
}

