/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.deployment.services;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.ow2.choreos.chef.Knife;
import org.ow2.choreos.chef.KnifeException;
import org.ow2.choreos.chef.impl.KnifeImpl;
import org.ow2.choreos.deployment.Configuration;
import org.ow2.choreos.deployment.services.diff.UpdateAction;
import org.ow2.choreos.deployment.services.recipe.RecipeBuilder;
import org.ow2.choreos.deployment.services.recipe.RecipeBuilderFactory;
import org.ow2.choreos.deployment.services.registry.DeployedServicesRegistry;
import org.ow2.choreos.nodes.ConfigNotAppliedException;
import org.ow2.choreos.nodes.NodePoolManager;
import org.ow2.choreos.nodes.datamodel.Config;
import org.ow2.choreos.nodes.datamodel.Node;
import org.ow2.choreos.services.ServiceNotDeletedException;
import org.ow2.choreos.services.ServiceNotDeployedException;
import org.ow2.choreos.services.ServiceNotFoundException;
import org.ow2.choreos.services.ServicesManager;
import org.ow2.choreos.services.UnhandledModificationException;
import org.ow2.choreos.services.datamodel.DeployableService;
import org.ow2.choreos.services.datamodel.DeployableServiceSpec;
import org.ow2.choreos.services.datamodel.PackageType;
import org.ow2.choreos.services.datamodel.Recipe;
import org.ow2.choreos.services.datamodel.ServiceInstance;
import org.ow2.choreos.services.datamodel.ServiceSpec;

public class ServicesManagerImpl
implements ServicesManager {
    private Logger logger = Logger.getLogger(ServicesManagerImpl.class);
    private DeployedServicesRegistry registry = DeployedServicesRegistry.getInstance();
    private NodePoolManager npm;
    protected Knife knife;

    public ServicesManagerImpl(NodePoolManager npm) {
        String CHEF_REPO = Configuration.get("CHEF_REPO");
        String CHEF_CONFIG_FILE = Configuration.get("CHEF_CONFIG_FILE");
        this.npm = npm;
        this.knife = new KnifeImpl(CHEF_CONFIG_FILE, CHEF_REPO);
    }

    public DeployableService createService(DeployableServiceSpec serviceSpec) throws ServiceNotDeployedException {
        DeployableService service = null;
        try {
            service = new DeployableService(serviceSpec);
        }
        catch (IllegalArgumentException e) {
            String message = "Invalid service spec";
            this.logger.error((Object)message, (Throwable)e);
            throw new ServiceNotDeployedException(serviceSpec.getUUID(), message);
        }
        if (serviceSpec.getPackageType() != PackageType.LEGACY) {
            service = this.deployService(service);
        }
        this.registry.addService(serviceSpec.getUUID(), service);
        return service;
    }

    private DeployableService deployService(DeployableService service) throws ServiceNotDeployedException {
        this.prepareDeployment(service);
        this.logger.debug((Object)"prepare deployment complete");
        this.executeDeployment(service, service.getSpec().getNumberOfInstances());
        this.logger.debug((Object)"execute deployment complete");
        return service;
    }

    private void prepareDeployment(DeployableService service) throws ServiceNotDeployedException {
        Recipe serviceRecipe = this.createRecipe(service);
        int i = 0;
        while (i < 5) {
            try {
                this.uploadRecipe(serviceRecipe);
                break;
            }
            catch (KnifeException e) {
                if (++i >= 4) {
                    this.logger.error((Object)("Could not upload recipe: " + e.getMessage()));
                    throw new ServiceNotDeployedException(service.getSpec().getUUID());
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {}
            }
        }
    }

    private Recipe createRecipe(DeployableService service) {
        PackageType type = service.getSpec().getPackageType();
        RecipeBuilder builder = RecipeBuilderFactory.getRecipeBuilderInstance(type);
        Recipe serviceRecipe = builder.createRecipe(service.getSpec());
        service.setRecipe(serviceRecipe);
        return serviceRecipe;
    }

    private void uploadRecipe(Recipe serviceRecipe) throws KnifeException {
        File folder = new File(serviceRecipe.getCookbookFolder());
        String parent = folder.getParent();
        this.logger.debug((Object)("Uploading recipe " + serviceRecipe.getName()));
        String result = this.knife.cookbook().upload(serviceRecipe.getCookbookName(), parent);
        this.logger.debug((Object)result);
    }

    private void executeDeployment(DeployableService service, int numberOfNewInstances) {
        Recipe serviceRecipe = service.getRecipe();
        String configName = serviceRecipe.getCookbookName() + "::" + serviceRecipe.getName();
        Config config = new Config(configName, service.getSpec().getResourceImpact(), numberOfNewInstances);
        List nodes = new ArrayList();
        try {
            nodes = this.npm.applyConfig(config);
        }
        catch (ConfigNotAppliedException e) {
            this.logger.error((Object)("Service " + service.getSpec().getUUID() + " not deployed: " + e.getMessage()));
        }
        catch (Exception e) {
            this.logger.error((Object)("Service " + service.getSpec().getUUID() + " not deployed: " + e.getMessage()));
        }
        for (Node node : nodes) {
            if (node.getHostname() != null && !node.getHostname().isEmpty() || node.getIp() != null && !node.getIp().isEmpty()) {
                this.logger.debug((Object)("nodeLocation= " + node.getHostname() + "; node IP=" + node.getIp()));
                service.addInstance(new ServiceInstance(node));
                continue;
            }
            this.logger.debug((Object)"request to create a node with no IP or hostname!");
        }
    }

    public DeployableService getService(String serviceId) throws ServiceNotFoundException {
        DeployableService s = this.registry.getService(serviceId);
        if (s == null) {
            throw new ServiceNotFoundException(serviceId, "Error while getting service from service map.");
        }
        return s;
    }

    public void deleteService(String serviceName) throws ServiceNotDeletedException {
        this.registry.deleteService(serviceName);
        if (this.registry.getService(serviceName) != null) {
            throw new ServiceNotDeletedException(serviceName);
        }
    }

    public DeployableService updateService(DeployableServiceSpec serviceSpec) throws UnhandledModificationException {
        DeployableService current;
        this.logger.info((Object)("Requested to update service " + serviceSpec.getUUID() + " with spec " + serviceSpec));
        try {
            this.logger.info((Object)("Trying to get service with id " + serviceSpec.getUUID() + " from \n" + this.registry.getServices()));
            current = this.getService(serviceSpec.getUUID());
            this.logger.info((Object)("getService got " + current));
        }
        catch (ServiceNotFoundException e) {
            this.logger.info((Object)("ServiceNotFoundException happened when trying to get service with id " + serviceSpec.getUUID()));
            this.logger.info((Object)("Exception message " + e.getMessage()));
            throw new UnhandledModificationException();
        }
        DeployableServiceSpec currentSpec = current.getSpec();
        this.logger.info((Object)("Current service spec " + currentSpec));
        List<UpdateAction> actions = this.getActions(currentSpec, serviceSpec);
        this.applyUpdate(current, serviceSpec, actions);
        this.logger.info((Object)("Updated service = " + current));
        return current;
    }

    private void applyUpdate(DeployableService currentService, DeployableServiceSpec requestedSpec, List<UpdateAction> actions) throws UnhandledModificationException {
        this.logger.info((Object)"Going to apply scheduled updates...");
        block5: for (UpdateAction a : actions) {
            this.logger.info((Object)("Selected update " + (Object)((Object)a)));
            switch (a) {
                case INCREASE_NUMBER_OF_REPLICAS: {
                    this.logger.info((Object)"Requesting to increase amount of replicas");
                    this.requestToIncreaseNumberOfInstances(currentService, (ServiceSpec)requestedSpec);
                    continue block5;
                }
                case DECREASE_NUMBER_OF_REPLICAS: {
                    this.logger.info((Object)"Requesting to decrease amount of replicas");
                    this.requestToDecreaseNumberOfInstances(currentService, (ServiceSpec)requestedSpec);
                    continue block5;
                }
                case MIGRATE: {
                    this.logger.info((Object)"Requesting to migrate replicas");
                    this.requestToMigrateServiceInstances(currentService, (ServiceSpec)requestedSpec);
                    continue block5;
                }
            }
            this.logger.info((Object)("Cannot apply modification " + (Object)((Object)a) + "; Raising UnhandledModificationException"));
            throw new UnhandledModificationException();
        }
        this.logger.info((Object)("Setting the new service spec for service " + currentService));
        String uuid = currentService.getSpec().getUUID();
        currentService.setSpec((ServiceSpec)requestedSpec);
        this.registry.addService(currentService.getSpec().getUUID(), currentService);
        this.registry.deleteService(uuid);
    }

    private List<UpdateAction> getActions(DeployableServiceSpec currentSpec, DeployableServiceSpec serviceSpec) {
        boolean foundKnownModification = false;
        ArrayList<UpdateAction> actions = new ArrayList<UpdateAction>();
        this.logger.info((Object)("Calculating changes on service spec \nOld = " + currentSpec + "\nNew = " + serviceSpec));
        if (currentSpec.getNumberOfInstances() < serviceSpec.getNumberOfInstances()) {
            this.logger.info((Object)"getAction has detected that must increase number of replicas");
            actions.add(UpdateAction.INCREASE_NUMBER_OF_REPLICAS);
            foundKnownModification = true;
        } else if (currentSpec.getNumberOfInstances() > serviceSpec.getNumberOfInstances()) {
            this.logger.info((Object)"getAction has detected that must decrease number of replicas");
            actions.add(UpdateAction.DECREASE_NUMBER_OF_REPLICAS);
            foundKnownModification = true;
        }
        if (currentSpec.getResourceImpact() != null && currentSpec.getResourceImpact().getMemory() != null && currentSpec.getResourceImpact().getMemory().ordinal() != serviceSpec.getResourceImpact().getMemory().ordinal()) {
            this.logger.info((Object)"getAction has detected that must to migrate service");
            actions.add(UpdateAction.MIGRATE);
            foundKnownModification = true;
        }
        if (!foundKnownModification) {
            this.logger.info((Object)"getAction has not detected any changes to do");
            actions.add(UpdateAction.UNKNOWN_MODIFICATION);
        }
        this.logger.info((Object)("Detected changes: " + actions));
        return actions;
    }

    private void requestToDecreaseNumberOfInstances(DeployableService currentService, ServiceSpec requestedSpec) {
        int decreaseAmount = currentService.getSpec().getNumberOfInstances() - requestedSpec.getNumberOfInstances();
        this.removeServiceInstances(currentService, decreaseAmount);
    }

    private void requestToIncreaseNumberOfInstances(DeployableService currentService, ServiceSpec requestedSpec) {
        int increaseAmount = requestedSpec.getNumberOfInstances() - currentService.getSpec().getNumberOfInstances();
        this.logger.info((Object)("requestToIncreaseNumberOfInstances: Increase amount = " + increaseAmount));
        this.addServiceInstances(currentService, increaseAmount);
    }

    private void requestToMigrateServiceInstances(DeployableService currentService, ServiceSpec requestedSpec) throws UnhandledModificationException {
        currentService.setSpec(requestedSpec);
        currentService.getInstances().clear();
        this.migrateServiceInstances(currentService);
    }

    private void migrateServiceInstances(DeployableService currentService) throws UnhandledModificationException {
        try {
            this.deployService(currentService);
        }
        catch (ServiceNotDeployedException e) {
            throw new UnhandledModificationException();
        }
    }

    private void removeServiceInstances(DeployableService currentService, int amount) {
        if (amount <= currentService.getInstances().size()) {
            for (int i = 0; i < amount; ++i) {
                currentService.getInstances().remove(0);
            }
        }
    }

    private void addServiceInstances(DeployableService current, int amount) {
        this.logger.info((Object)("Requesting to execute deploy of " + amount + " replicas for" + current));
        this.executeDeployment(current, amount);
    }
}

