/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.deployment.services.registry;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.ow2.choreos.services.datamodel.DeployableService;

public class DeployedServicesRegistry {
    private ConcurrentMap<String, DeployableService> availableServices = new ConcurrentHashMap<String, DeployableService>();
    private static DeployedServicesRegistry INSTANCE = null;

    public void addService(String serviceId, DeployableService service) {
        this.availableServices.put(serviceId, service);
    }

    public DeployableService getService(String serviceId) {
        return (DeployableService)this.availableServices.get(serviceId);
    }

    public Collection<DeployableService> getServices() {
        return this.availableServices.values();
    }

    public void deleteService(String serviceId) {
        if (this.availableServices.remove(serviceId) == null) {
            throw new IllegalArgumentException("Service " + serviceId + " not registered");
        }
    }

    private DeployedServicesRegistry() {
    }

    public static DeployedServicesRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DeployedServicesRegistry();
        }
        return INSTANCE;
    }
}

