/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.deployment.services.rest;

import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;
import org.ow2.choreos.deployment.Configuration;
import org.ow2.choreos.deployment.nodes.NPMImpl;
import org.ow2.choreos.deployment.nodes.cloudprovider.CloudProviderFactory;
import org.ow2.choreos.deployment.services.ServicesManagerImpl;
import org.ow2.choreos.nodes.NodePoolManager;
import org.ow2.choreos.services.ServiceNotDeletedException;
import org.ow2.choreos.services.ServiceNotDeployedException;
import org.ow2.choreos.services.ServiceNotFoundException;
import org.ow2.choreos.services.ServiceNotModifiedException;
import org.ow2.choreos.services.ServicesManager;
import org.ow2.choreos.services.UnhandledModificationException;
import org.ow2.choreos.services.datamodel.DeployableService;
import org.ow2.choreos.services.datamodel.DeployableServiceSpec;
import org.ow2.choreos.services.datamodel.ServiceInstance;

@Path(value="services")
public class ServicesResource {
    private Logger logger = Logger.getLogger(ServicesResource.class);
    private String cloudProviderType = Configuration.get("CLOUD_PROVIDER");
    protected NodePoolManager npm = new NPMImpl(CloudProviderFactory.getInstance(this.cloudProviderType));
    protected ServicesManager servicesManager = new ServicesManagerImpl(this.npm);

    public ServicesResource() {
        String cloudProviderType = Configuration.get("CLOUD_PROVIDER");
        this.npm = new NPMImpl(CloudProviderFactory.getInstance(cloudProviderType));
        this.servicesManager = new ServicesManagerImpl(this.npm);
    }

    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public Response deployService(DeployableServiceSpec serviceSpec, @Context UriInfo uriInfo) {
        DeployableService service;
        if (serviceSpec.getPackageUri() == null || serviceSpec.getPackageUri().isEmpty() || serviceSpec.getPackageType() == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        this.logger.debug((Object)("Request to deploy " + serviceSpec.getPackageUri()));
        try {
            service = this.servicesManager.createService(serviceSpec);
        }
        catch (ServiceNotDeployedException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        this.logger.info((Object)(service.getSpec().getUUID() + " configured to be deployed on " + service.getUris()));
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder = uriBuilder.path(ServicesResource.class).path(service.getSpec().getUUID());
        URI location = uriBuilder.build(new Object[0]);
        return Response.created((URI)location).entity((Object)service).build();
    }

    @GET
    @Path(value="{uuid}")
    @Produces(value={"application/xml"})
    public Response getService(@PathParam(value="uuid") String uuid) {
        DeployableService service;
        if (uuid == null || uuid.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        this.logger.debug((Object)("Request to get service " + uuid));
        try {
            service = this.servicesManager.getService(uuid);
        }
        catch (ServiceNotFoundException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.ok((Object)service).build();
    }

    @GET
    @Path(value="{uuid}/instances")
    @Produces(value={"application/xml"})
    public Response getServiceInstances(@PathParam(value="uuid") String uuid) {
        DeployableService service;
        if (uuid == null || uuid.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        this.logger.debug((Object)("Request to get instances of service " + uuid));
        try {
            service = this.servicesManager.getService(uuid);
        }
        catch (ServiceNotFoundException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.ok((Object)service.getInstances()).build();
    }

    @GET
    @Path(value="{uuid}/instances/{instanceID}")
    @Produces(value={"application/xml"})
    public Response getServiceInstance(@PathParam(value="uuid") String uuid, @PathParam(value="instanceId") String instanceId) {
        ServiceInstance instance;
        if (uuid == null || uuid.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        this.logger.debug((Object)("Request to get instance " + instanceId + " of service " + uuid));
        try {
            DeployableService service = this.servicesManager.getService(uuid);
            instance = service.getInstance(instanceId);
        }
        catch (ServiceNotFoundException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.ok((Object)instance).build();
    }

    @DELETE
    @Path(value="{uuid}")
    public Response deleteService(@PathParam(value="uuid") String uuid) {
        if (uuid == null || uuid.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        this.logger.debug((Object)("Request to delete service " + uuid));
        try {
            this.servicesManager.deleteService(uuid);
        }
        catch (ServiceNotDeletedException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (ServiceNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.logger.info((Object)("Service " + uuid + " deleted"));
        return Response.ok().build();
    }

    @POST
    @Path(value="{uuid}")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public Response updateService(DeployableServiceSpec serviceSpec, @PathParam(value="uuid") String uuid, @Context UriInfo uriInfo) {
        DeployableService service;
        if (serviceSpec.getPackageUri() == null || serviceSpec.getPackageUri().isEmpty() || serviceSpec.getPackageType() == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        this.logger.debug((Object)("Request to update " + uuid));
        try {
            service = this.servicesManager.updateService(serviceSpec);
        }
        catch (ServiceNotModifiedException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (UnhandledModificationException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        this.logger.info((Object)(uuid + " updated. Running on " + service.getUris()));
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder = uriBuilder.path(ServicesResource.class).path(service.getSpec().getUUID());
        Response build = Response.ok((Object)service).build();
        return build;
    }
}

