#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_01bdbffc-0ea0-49bd-912a-9c9ac4698e22_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-01bdbffc-0ea0-49bd-912a-9c9ac4698e22.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-01bdbffc-0ea0-49bd-912a-9c9ac4698e22.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['01bdbffc-0ea0-49bd-912a-9c9ac4698e22']['InstallationDir']}/service-01bdbffc-0ea0-49bd-912a-9c9ac4698e22.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-01bdbffc-0ea0-49bd-912a-9c9ac4698e22.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['01bdbffc-0ea0-49bd-912a-9c9ac4698e22']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['01bdbffc-0ea0-49bd-912a-9c9ac4698e22']['InstallationDir']}/service-01bdbffc-0ea0-49bd-912a-9c9ac4698e22.jar" do
  		source "#{node['CHOReOSData']['serviceData']['01bdbffc-0ea0-49bd-912a-9c9ac4698e22']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_01bdbffc-0ea0-49bd-912a-9c9ac4698e22_jar]"
		notifies :start, "service[service_01bdbffc-0ea0-49bd-912a-9c9ac4698e22_jar]"
	end
end

if node['CHOReOSData']['serviceData']['01bdbffc-0ea0-49bd-912a-9c9ac4698e22']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['01bdbffc-0ea0-49bd-912a-9c9ac4698e22']['InstallationDir']}/service-01bdbffc-0ea0-49bd-912a-9c9ac4698e22.jar" do
		notifies :stop, "service[service_01bdbffc-0ea0-49bd-912a-9c9ac4698e22_jar]", :immediately
		#notifies :disable, "service[service_01bdbffc-0ea0-49bd-912a-9c9ac4698e22_jar]", :immediately
		action :delete
	end
end