#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_139e1cc6-1df9-4641-b7de-2310dab5cadf_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-139e1cc6-1df9-4641-b7de-2310dab5cadf.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-139e1cc6-1df9-4641-b7de-2310dab5cadf.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['139e1cc6-1df9-4641-b7de-2310dab5cadf']['InstallationDir']}/service-139e1cc6-1df9-4641-b7de-2310dab5cadf.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-139e1cc6-1df9-4641-b7de-2310dab5cadf.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['139e1cc6-1df9-4641-b7de-2310dab5cadf']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['139e1cc6-1df9-4641-b7de-2310dab5cadf']['InstallationDir']}/service-139e1cc6-1df9-4641-b7de-2310dab5cadf.jar" do
  		source "#{node['CHOReOSData']['serviceData']['139e1cc6-1df9-4641-b7de-2310dab5cadf']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_139e1cc6-1df9-4641-b7de-2310dab5cadf_jar]"
		notifies :start, "service[service_139e1cc6-1df9-4641-b7de-2310dab5cadf_jar]"
	end
end

if node['CHOReOSData']['serviceData']['139e1cc6-1df9-4641-b7de-2310dab5cadf']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['139e1cc6-1df9-4641-b7de-2310dab5cadf']['InstallationDir']}/service-139e1cc6-1df9-4641-b7de-2310dab5cadf.jar" do
		notifies :stop, "service[service_139e1cc6-1df9-4641-b7de-2310dab5cadf_jar]", :immediately
		#notifies :disable, "service[service_139e1cc6-1df9-4641-b7de-2310dab5cadf_jar]", :immediately
		action :delete
	end
end