#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_23c3b2f6-bca0-471c-8c72-7edc42ba06eb_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-23c3b2f6-bca0-471c-8c72-7edc42ba06eb.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-23c3b2f6-bca0-471c-8c72-7edc42ba06eb.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['23c3b2f6-bca0-471c-8c72-7edc42ba06eb']['InstallationDir']}/service-23c3b2f6-bca0-471c-8c72-7edc42ba06eb.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-23c3b2f6-bca0-471c-8c72-7edc42ba06eb.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['23c3b2f6-bca0-471c-8c72-7edc42ba06eb']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['23c3b2f6-bca0-471c-8c72-7edc42ba06eb']['InstallationDir']}/service-23c3b2f6-bca0-471c-8c72-7edc42ba06eb.jar" do
  		source "#{node['CHOReOSData']['serviceData']['23c3b2f6-bca0-471c-8c72-7edc42ba06eb']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_23c3b2f6-bca0-471c-8c72-7edc42ba06eb_jar]"
		notifies :start, "service[service_23c3b2f6-bca0-471c-8c72-7edc42ba06eb_jar]"
	end
end

if node['CHOReOSData']['serviceData']['23c3b2f6-bca0-471c-8c72-7edc42ba06eb']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['23c3b2f6-bca0-471c-8c72-7edc42ba06eb']['InstallationDir']}/service-23c3b2f6-bca0-471c-8c72-7edc42ba06eb.jar" do
		notifies :stop, "service[service_23c3b2f6-bca0-471c-8c72-7edc42ba06eb_jar]", :immediately
		#notifies :disable, "service[service_23c3b2f6-bca0-471c-8c72-7edc42ba06eb_jar]", :immediately
		action :delete
	end
end