#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_3141fbd8-af12-4b59-9064-1fc5ec7caeb2_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service3141fbd8-af12-4b59-9064-1fc5ec7caeb2Deploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['3141fbd8-af12-4b59-9064-1fc5ec7caeb2']['installationDir']}/service3141fbd8-af12-4b59-9064-1fc5ec7caeb2Deploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service3141fbd8-af12-4b59-9064-1fc5ec7caeb2Deploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['3141fbd8-af12-4b59-9064-1fc5ec7caeb2']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['3141fbd8-af12-4b59-9064-1fc5ec7caeb2']['InstallationDir']}/service3141fbd8-af12-4b59-9064-1fc5ec7caeb2Deploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['3141fbd8-af12-4b59-9064-1fc5ec7caeb2']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_3141fbd8-af12-4b59-9064-1fc5ec7caeb2_jar]"
		notifies :start, "service[service_3141fbd8-af12-4b59-9064-1fc5ec7caeb2_jar]"
	end
end

if node['CHOReOSData']['serviceData']['3141fbd8-af12-4b59-9064-1fc5ec7caeb2']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['3141fbd8-af12-4b59-9064-1fc5ec7caeb2']['InstallationDir']}/service3141fbd8-af12-4b59-9064-1fc5ec7caeb2Deploy.jar" do
		notifies :stop, "service[service_3141fbd8-af12-4b59-9064-1fc5ec7caeb2_jar]", :immediately
		#notifies :disable, "service[service_3141fbd8-af12-4b59-9064-1fc5ec7caeb2_jar]", :immediately
		action :delete
	end
end