#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_3619d1eb-02f5-413f-8b84-39cd307e5acd_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-3619d1eb-02f5-413f-8b84-39cd307e5acd.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-3619d1eb-02f5-413f-8b84-39cd307e5acd.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['3619d1eb-02f5-413f-8b84-39cd307e5acd']['InstallationDir']}/service-3619d1eb-02f5-413f-8b84-39cd307e5acd.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-3619d1eb-02f5-413f-8b84-39cd307e5acd.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['3619d1eb-02f5-413f-8b84-39cd307e5acd']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['3619d1eb-02f5-413f-8b84-39cd307e5acd']['InstallationDir']}/service-3619d1eb-02f5-413f-8b84-39cd307e5acd.jar" do
  		source "#{node['CHOReOSData']['serviceData']['3619d1eb-02f5-413f-8b84-39cd307e5acd']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_3619d1eb-02f5-413f-8b84-39cd307e5acd_jar]"
		notifies :start, "service[service_3619d1eb-02f5-413f-8b84-39cd307e5acd_jar]"
	end
end

if node['CHOReOSData']['serviceData']['3619d1eb-02f5-413f-8b84-39cd307e5acd']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['3619d1eb-02f5-413f-8b84-39cd307e5acd']['InstallationDir']}/service-3619d1eb-02f5-413f-8b84-39cd307e5acd.jar" do
		notifies :stop, "service[service_3619d1eb-02f5-413f-8b84-39cd307e5acd_jar]", :immediately
		#notifies :disable, "service[service_3619d1eb-02f5-413f-8b84-39cd307e5acd_jar]", :immediately
		action :delete
	end
end