#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_42bf3941-bcd7-432b-a46c-bcffa89d2988_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-42bf3941-bcd7-432b-a46c-bcffa89d2988.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-42bf3941-bcd7-432b-a46c-bcffa89d2988.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['42bf3941-bcd7-432b-a46c-bcffa89d2988']['InstallationDir']}/service-42bf3941-bcd7-432b-a46c-bcffa89d2988.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-42bf3941-bcd7-432b-a46c-bcffa89d2988.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['42bf3941-bcd7-432b-a46c-bcffa89d2988']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['42bf3941-bcd7-432b-a46c-bcffa89d2988']['InstallationDir']}/service-42bf3941-bcd7-432b-a46c-bcffa89d2988.jar" do
  		source "#{node['CHOReOSData']['serviceData']['42bf3941-bcd7-432b-a46c-bcffa89d2988']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_42bf3941-bcd7-432b-a46c-bcffa89d2988_jar]"
		notifies :start, "service[service_42bf3941-bcd7-432b-a46c-bcffa89d2988_jar]"
	end
end

if node['CHOReOSData']['serviceData']['42bf3941-bcd7-432b-a46c-bcffa89d2988']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['42bf3941-bcd7-432b-a46c-bcffa89d2988']['InstallationDir']}/service-42bf3941-bcd7-432b-a46c-bcffa89d2988.jar" do
		notifies :stop, "service[service_42bf3941-bcd7-432b-a46c-bcffa89d2988_jar]", :immediately
		#notifies :disable, "service[service_42bf3941-bcd7-432b-a46c-bcffa89d2988_jar]", :immediately
		action :delete
	end
end