#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_51a0d753-af13-4ded-9ed0-03839853351d_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-51a0d753-af13-4ded-9ed0-03839853351d.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-51a0d753-af13-4ded-9ed0-03839853351d.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['51a0d753-af13-4ded-9ed0-03839853351d']['InstallationDir']}/service-51a0d753-af13-4ded-9ed0-03839853351d.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-51a0d753-af13-4ded-9ed0-03839853351d.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['51a0d753-af13-4ded-9ed0-03839853351d']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['51a0d753-af13-4ded-9ed0-03839853351d']['InstallationDir']}/service-51a0d753-af13-4ded-9ed0-03839853351d.jar" do
  		source "#{node['CHOReOSData']['serviceData']['51a0d753-af13-4ded-9ed0-03839853351d']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_51a0d753-af13-4ded-9ed0-03839853351d_jar]"
		notifies :start, "service[service_51a0d753-af13-4ded-9ed0-03839853351d_jar]"
	end
end

if node['CHOReOSData']['serviceData']['51a0d753-af13-4ded-9ed0-03839853351d']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['51a0d753-af13-4ded-9ed0-03839853351d']['InstallationDir']}/service-51a0d753-af13-4ded-9ed0-03839853351d.jar" do
		notifies :stop, "service[service_51a0d753-af13-4ded-9ed0-03839853351d_jar]", :immediately
		#notifies :disable, "service[service_51a0d753-af13-4ded-9ed0-03839853351d_jar]", :immediately
		action :delete
	end
end