#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_59f6622e-d2ac-4df8-98df-ee2a356f6923_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-59f6622e-d2ac-4df8-98df-ee2a356f6923.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-59f6622e-d2ac-4df8-98df-ee2a356f6923.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['59f6622e-d2ac-4df8-98df-ee2a356f6923']['InstallationDir']}/service-59f6622e-d2ac-4df8-98df-ee2a356f6923.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-59f6622e-d2ac-4df8-98df-ee2a356f6923.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['59f6622e-d2ac-4df8-98df-ee2a356f6923']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['59f6622e-d2ac-4df8-98df-ee2a356f6923']['InstallationDir']}/service-59f6622e-d2ac-4df8-98df-ee2a356f6923.jar" do
  		source "#{node['CHOReOSData']['serviceData']['59f6622e-d2ac-4df8-98df-ee2a356f6923']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_59f6622e-d2ac-4df8-98df-ee2a356f6923_jar]"
		notifies :start, "service[service_59f6622e-d2ac-4df8-98df-ee2a356f6923_jar]"
	end
end

if node['CHOReOSData']['serviceData']['59f6622e-d2ac-4df8-98df-ee2a356f6923']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['59f6622e-d2ac-4df8-98df-ee2a356f6923']['InstallationDir']}/service-59f6622e-d2ac-4df8-98df-ee2a356f6923.jar" do
		notifies :stop, "service[service_59f6622e-d2ac-4df8-98df-ee2a356f6923_jar]", :immediately
		#notifies :disable, "service[service_59f6622e-d2ac-4df8-98df-ee2a356f6923_jar]", :immediately
		action :delete
	end
end