#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_5a326f12-1fd2-46b3-aab0-51fc13ce9214_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-5a326f12-1fd2-46b3-aab0-51fc13ce9214.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-5a326f12-1fd2-46b3-aab0-51fc13ce9214.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['5a326f12-1fd2-46b3-aab0-51fc13ce9214']['InstallationDir']}/service-5a326f12-1fd2-46b3-aab0-51fc13ce9214.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-5a326f12-1fd2-46b3-aab0-51fc13ce9214.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['5a326f12-1fd2-46b3-aab0-51fc13ce9214']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['5a326f12-1fd2-46b3-aab0-51fc13ce9214']['InstallationDir']}/service-5a326f12-1fd2-46b3-aab0-51fc13ce9214.jar" do
  		source "#{node['CHOReOSData']['serviceData']['5a326f12-1fd2-46b3-aab0-51fc13ce9214']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_5a326f12-1fd2-46b3-aab0-51fc13ce9214_jar]"
		notifies :start, "service[service_5a326f12-1fd2-46b3-aab0-51fc13ce9214_jar]"
	end
end

if node['CHOReOSData']['serviceData']['5a326f12-1fd2-46b3-aab0-51fc13ce9214']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['5a326f12-1fd2-46b3-aab0-51fc13ce9214']['InstallationDir']}/service-5a326f12-1fd2-46b3-aab0-51fc13ce9214.jar" do
		notifies :stop, "service[service_5a326f12-1fd2-46b3-aab0-51fc13ce9214_jar]", :immediately
		#notifies :disable, "service[service_5a326f12-1fd2-46b3-aab0-51fc13ce9214_jar]", :immediately
		action :delete
	end
end