#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_5d7a513e-b064-43ca-8290-6c0f99892e7f_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service5d7a513e-b064-43ca-8290-6c0f99892e7fDeploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['5d7a513e-b064-43ca-8290-6c0f99892e7f']['installationDir']}/service5d7a513e-b064-43ca-8290-6c0f99892e7fDeploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service5d7a513e-b064-43ca-8290-6c0f99892e7fDeploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['5d7a513e-b064-43ca-8290-6c0f99892e7f']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['5d7a513e-b064-43ca-8290-6c0f99892e7f']['InstallationDir']}/service5d7a513e-b064-43ca-8290-6c0f99892e7fDeploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['5d7a513e-b064-43ca-8290-6c0f99892e7f']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_5d7a513e-b064-43ca-8290-6c0f99892e7f_jar]"
		notifies :start, "service[service_5d7a513e-b064-43ca-8290-6c0f99892e7f_jar]"
	end
end

if node['CHOReOSData']['serviceData']['5d7a513e-b064-43ca-8290-6c0f99892e7f']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['5d7a513e-b064-43ca-8290-6c0f99892e7f']['InstallationDir']}/service5d7a513e-b064-43ca-8290-6c0f99892e7fDeploy.jar" do
		notifies :stop, "service[service_5d7a513e-b064-43ca-8290-6c0f99892e7f_jar]", :immediately
		#notifies :disable, "service[service_5d7a513e-b064-43ca-8290-6c0f99892e7f_jar]", :immediately
		action :delete
	end
end