#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_5e570fe7-59ec-48d2-8bf0-0c5f21fad63b_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service5e570fe7-59ec-48d2-8bf0-0c5f21fad63bDeploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['5e570fe7-59ec-48d2-8bf0-0c5f21fad63b']['installationDir']}/service5e570fe7-59ec-48d2-8bf0-0c5f21fad63bDeploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service5e570fe7-59ec-48d2-8bf0-0c5f21fad63bDeploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['5e570fe7-59ec-48d2-8bf0-0c5f21fad63b']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['5e570fe7-59ec-48d2-8bf0-0c5f21fad63b']['InstallationDir']}/service5e570fe7-59ec-48d2-8bf0-0c5f21fad63bDeploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['5e570fe7-59ec-48d2-8bf0-0c5f21fad63b']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_5e570fe7-59ec-48d2-8bf0-0c5f21fad63b_jar]"
		notifies :start, "service[service_5e570fe7-59ec-48d2-8bf0-0c5f21fad63b_jar]"
	end
end

if node['CHOReOSData']['serviceData']['5e570fe7-59ec-48d2-8bf0-0c5f21fad63b']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['5e570fe7-59ec-48d2-8bf0-0c5f21fad63b']['InstallationDir']}/service5e570fe7-59ec-48d2-8bf0-0c5f21fad63bDeploy.jar" do
		notifies :stop, "service[service_5e570fe7-59ec-48d2-8bf0-0c5f21fad63b_jar]", :immediately
		#notifies :disable, "service[service_5e570fe7-59ec-48d2-8bf0-0c5f21fad63b_jar]", :immediately
		action :delete
	end
end