#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_69897406-c939-4dd8-8bec-a4d54011a2bb_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-69897406-c939-4dd8-8bec-a4d54011a2bb.pid --exec bash -c 'echo $$ > /var/run/service-69897406-c939-4dd8-8bec-a4d54011a2bb.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['69897406-c939-4dd8-8bec-a4d54011a2bb']['installationDir']}/service-69897406-c939-4dd8-8bec-a4d54011a2bb.jar' "
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-69897406-c939-4dd8-8bec-a4d54011a2bb.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['69897406-c939-4dd8-8bec-a4d54011a2bb']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['69897406-c939-4dd8-8bec-a4d54011a2bb']['InstallationDir']}/service-69897406-c939-4dd8-8bec-a4d54011a2bb.jar" do
  		source "#{node['CHOReOSData']['serviceData']['69897406-c939-4dd8-8bec-a4d54011a2bb']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_69897406-c939-4dd8-8bec-a4d54011a2bb_jar]"
		notifies :start, "service[service_69897406-c939-4dd8-8bec-a4d54011a2bb_jar]"
	end
end

if node['CHOReOSData']['serviceData']['69897406-c939-4dd8-8bec-a4d54011a2bb']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['69897406-c939-4dd8-8bec-a4d54011a2bb']['InstallationDir']}/service-69897406-c939-4dd8-8bec-a4d54011a2bb.jar" do
		notifies :stop, "service[service_69897406-c939-4dd8-8bec-a4d54011a2bb_jar]", :immediately
		#notifies :disable, "service[service_69897406-c939-4dd8-8bec-a4d54011a2bb_jar]", :immediately
		action :delete
	end
end