#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_6b896d2e-2d71-46a4-b8c9-db3476ed99a9_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-6b896d2e-2d71-46a4-b8c9-db3476ed99a9.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-6b896d2e-2d71-46a4-b8c9-db3476ed99a9.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['6b896d2e-2d71-46a4-b8c9-db3476ed99a9']['InstallationDir']}/service-6b896d2e-2d71-46a4-b8c9-db3476ed99a9.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-6b896d2e-2d71-46a4-b8c9-db3476ed99a9.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['6b896d2e-2d71-46a4-b8c9-db3476ed99a9']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['6b896d2e-2d71-46a4-b8c9-db3476ed99a9']['InstallationDir']}/service-6b896d2e-2d71-46a4-b8c9-db3476ed99a9.jar" do
  		source "#{node['CHOReOSData']['serviceData']['6b896d2e-2d71-46a4-b8c9-db3476ed99a9']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_6b896d2e-2d71-46a4-b8c9-db3476ed99a9_jar]"
		notifies :start, "service[service_6b896d2e-2d71-46a4-b8c9-db3476ed99a9_jar]"
	end
end

if node['CHOReOSData']['serviceData']['6b896d2e-2d71-46a4-b8c9-db3476ed99a9']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['6b896d2e-2d71-46a4-b8c9-db3476ed99a9']['InstallationDir']}/service-6b896d2e-2d71-46a4-b8c9-db3476ed99a9.jar" do
		notifies :stop, "service[service_6b896d2e-2d71-46a4-b8c9-db3476ed99a9_jar]", :immediately
		#notifies :disable, "service[service_6b896d2e-2d71-46a4-b8c9-db3476ed99a9_jar]", :immediately
		action :delete
	end
end