#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_7782354d-4b88-4035-a0ab-6693d3f9d281_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-7782354d-4b88-4035-a0ab-6693d3f9d281.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-7782354d-4b88-4035-a0ab-6693d3f9d281.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['7782354d-4b88-4035-a0ab-6693d3f9d281']['InstallationDir']}/service-7782354d-4b88-4035-a0ab-6693d3f9d281.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-7782354d-4b88-4035-a0ab-6693d3f9d281.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['7782354d-4b88-4035-a0ab-6693d3f9d281']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['7782354d-4b88-4035-a0ab-6693d3f9d281']['InstallationDir']}/service-7782354d-4b88-4035-a0ab-6693d3f9d281.jar" do
  		source "#{node['CHOReOSData']['serviceData']['7782354d-4b88-4035-a0ab-6693d3f9d281']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_7782354d-4b88-4035-a0ab-6693d3f9d281_jar]"
		notifies :start, "service[service_7782354d-4b88-4035-a0ab-6693d3f9d281_jar]"
	end
end

if node['CHOReOSData']['serviceData']['7782354d-4b88-4035-a0ab-6693d3f9d281']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['7782354d-4b88-4035-a0ab-6693d3f9d281']['InstallationDir']}/service-7782354d-4b88-4035-a0ab-6693d3f9d281.jar" do
		notifies :stop, "service[service_7782354d-4b88-4035-a0ab-6693d3f9d281_jar]", :immediately
		#notifies :disable, "service[service_7782354d-4b88-4035-a0ab-6693d3f9d281_jar]", :immediately
		action :delete
	end
end