#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_9b72e80c-ef2d-4e33-b3d6-ede73e3ba99d_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-9b72e80c-ef2d-4e33-b3d6-ede73e3ba99d.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-9b72e80c-ef2d-4e33-b3d6-ede73e3ba99d.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['9b72e80c-ef2d-4e33-b3d6-ede73e3ba99d']['InstallationDir']}/service-9b72e80c-ef2d-4e33-b3d6-ede73e3ba99d.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-9b72e80c-ef2d-4e33-b3d6-ede73e3ba99d.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['9b72e80c-ef2d-4e33-b3d6-ede73e3ba99d']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['9b72e80c-ef2d-4e33-b3d6-ede73e3ba99d']['InstallationDir']}/service-9b72e80c-ef2d-4e33-b3d6-ede73e3ba99d.jar" do
  		source "#{node['CHOReOSData']['serviceData']['9b72e80c-ef2d-4e33-b3d6-ede73e3ba99d']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_9b72e80c-ef2d-4e33-b3d6-ede73e3ba99d_jar]"
		notifies :start, "service[service_9b72e80c-ef2d-4e33-b3d6-ede73e3ba99d_jar]"
	end
end

if node['CHOReOSData']['serviceData']['9b72e80c-ef2d-4e33-b3d6-ede73e3ba99d']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['9b72e80c-ef2d-4e33-b3d6-ede73e3ba99d']['InstallationDir']}/service-9b72e80c-ef2d-4e33-b3d6-ede73e3ba99d.jar" do
		notifies :stop, "service[service_9b72e80c-ef2d-4e33-b3d6-ede73e3ba99d_jar]", :immediately
		#notifies :disable, "service[service_9b72e80c-ef2d-4e33-b3d6-ede73e3ba99d_jar]", :immediately
		action :delete
	end
end