#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_9ee5b68a-5eab-48af-a45e-d4ea1e6b3ccf_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-9ee5b68a-5eab-48af-a45e-d4ea1e6b3ccf.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-9ee5b68a-5eab-48af-a45e-d4ea1e6b3ccf.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['9ee5b68a-5eab-48af-a45e-d4ea1e6b3ccf']['InstallationDir']}/service-9ee5b68a-5eab-48af-a45e-d4ea1e6b3ccf.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-9ee5b68a-5eab-48af-a45e-d4ea1e6b3ccf.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['9ee5b68a-5eab-48af-a45e-d4ea1e6b3ccf']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['9ee5b68a-5eab-48af-a45e-d4ea1e6b3ccf']['InstallationDir']}/service-9ee5b68a-5eab-48af-a45e-d4ea1e6b3ccf.jar" do
  		source "#{node['CHOReOSData']['serviceData']['9ee5b68a-5eab-48af-a45e-d4ea1e6b3ccf']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_9ee5b68a-5eab-48af-a45e-d4ea1e6b3ccf_jar]"
		notifies :start, "service[service_9ee5b68a-5eab-48af-a45e-d4ea1e6b3ccf_jar]"
	end
end

if node['CHOReOSData']['serviceData']['9ee5b68a-5eab-48af-a45e-d4ea1e6b3ccf']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['9ee5b68a-5eab-48af-a45e-d4ea1e6b3ccf']['InstallationDir']}/service-9ee5b68a-5eab-48af-a45e-d4ea1e6b3ccf.jar" do
		notifies :stop, "service[service_9ee5b68a-5eab-48af-a45e-d4ea1e6b3ccf_jar]", :immediately
		#notifies :disable, "service[service_9ee5b68a-5eab-48af-a45e-d4ea1e6b3ccf_jar]", :immediately
		action :delete
	end
end