#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_9fc6ca26-afbb-40a6-84d2-5e7181cf127f_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-9fc6ca26-afbb-40a6-84d2-5e7181cf127f.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-9fc6ca26-afbb-40a6-84d2-5e7181cf127f.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['9fc6ca26-afbb-40a6-84d2-5e7181cf127f']['InstallationDir']}/service-9fc6ca26-afbb-40a6-84d2-5e7181cf127f.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-9fc6ca26-afbb-40a6-84d2-5e7181cf127f.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['9fc6ca26-afbb-40a6-84d2-5e7181cf127f']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['9fc6ca26-afbb-40a6-84d2-5e7181cf127f']['InstallationDir']}/service-9fc6ca26-afbb-40a6-84d2-5e7181cf127f.jar" do
  		source "#{node['CHOReOSData']['serviceData']['9fc6ca26-afbb-40a6-84d2-5e7181cf127f']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_9fc6ca26-afbb-40a6-84d2-5e7181cf127f_jar]"
		notifies :start, "service[service_9fc6ca26-afbb-40a6-84d2-5e7181cf127f_jar]"
	end
end

if node['CHOReOSData']['serviceData']['9fc6ca26-afbb-40a6-84d2-5e7181cf127f']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['9fc6ca26-afbb-40a6-84d2-5e7181cf127f']['InstallationDir']}/service-9fc6ca26-afbb-40a6-84d2-5e7181cf127f.jar" do
		notifies :stop, "service[service_9fc6ca26-afbb-40a6-84d2-5e7181cf127f_jar]", :immediately
		#notifies :disable, "service[service_9fc6ca26-afbb-40a6-84d2-5e7181cf127f_jar]", :immediately
		action :delete
	end
end