#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_Airline_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/serviceAirlineDeploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['Airline']['installationDir']}/serviceAirlineDeploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/serviceAirlineDeploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['Airline']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['Airline']['InstallationDir']}/serviceAirlineDeploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['Airline']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_Airline_jar]"
		notifies :start, "service[service_Airline_jar]"
	end
end

if node['CHOReOSData']['serviceData']['Airline']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['Airline']['InstallationDir']}/serviceAirlineDeploy.jar" do
		notifies :stop, "service[service_Airline_jar]", :immediately
		#notifies :disable, "service[service_Airline_jar]", :immediately
		action :delete
	end
end