#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_ab757a12-f45e-438c-9fac-b2d839f1a399_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-ab757a12-f45e-438c-9fac-b2d839f1a399.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-ab757a12-f45e-438c-9fac-b2d839f1a399.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['ab757a12-f45e-438c-9fac-b2d839f1a399']['InstallationDir']}/service-ab757a12-f45e-438c-9fac-b2d839f1a399.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-ab757a12-f45e-438c-9fac-b2d839f1a399.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['ab757a12-f45e-438c-9fac-b2d839f1a399']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['ab757a12-f45e-438c-9fac-b2d839f1a399']['InstallationDir']}/service-ab757a12-f45e-438c-9fac-b2d839f1a399.jar" do
  		source "#{node['CHOReOSData']['serviceData']['ab757a12-f45e-438c-9fac-b2d839f1a399']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_ab757a12-f45e-438c-9fac-b2d839f1a399_jar]"
		notifies :start, "service[service_ab757a12-f45e-438c-9fac-b2d839f1a399_jar]"
	end
end

if node['CHOReOSData']['serviceData']['ab757a12-f45e-438c-9fac-b2d839f1a399']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['ab757a12-f45e-438c-9fac-b2d839f1a399']['InstallationDir']}/service-ab757a12-f45e-438c-9fac-b2d839f1a399.jar" do
		notifies :stop, "service[service_ab757a12-f45e-438c-9fac-b2d839f1a399_jar]", :immediately
		#notifies :disable, "service[service_ab757a12-f45e-438c-9fac-b2d839f1a399_jar]", :immediately
		action :delete
	end
end