#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_aba02c3b-3435-4c58-80df-b65e93aa64ce_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-aba02c3b-3435-4c58-80df-b65e93aa64ce.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-aba02c3b-3435-4c58-80df-b65e93aa64ce.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['aba02c3b-3435-4c58-80df-b65e93aa64ce']['InstallationDir']}/service-aba02c3b-3435-4c58-80df-b65e93aa64ce.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-aba02c3b-3435-4c58-80df-b65e93aa64ce.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['aba02c3b-3435-4c58-80df-b65e93aa64ce']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['aba02c3b-3435-4c58-80df-b65e93aa64ce']['InstallationDir']}/service-aba02c3b-3435-4c58-80df-b65e93aa64ce.jar" do
  		source "#{node['CHOReOSData']['serviceData']['aba02c3b-3435-4c58-80df-b65e93aa64ce']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_aba02c3b-3435-4c58-80df-b65e93aa64ce_jar]"
		notifies :start, "service[service_aba02c3b-3435-4c58-80df-b65e93aa64ce_jar]"
	end
end

if node['CHOReOSData']['serviceData']['aba02c3b-3435-4c58-80df-b65e93aa64ce']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['aba02c3b-3435-4c58-80df-b65e93aa64ce']['InstallationDir']}/service-aba02c3b-3435-4c58-80df-b65e93aa64ce.jar" do
		notifies :stop, "service[service_aba02c3b-3435-4c58-80df-b65e93aa64ce_jar]", :immediately
		#notifies :disable, "service[service_aba02c3b-3435-4c58-80df-b65e93aa64ce_jar]", :immediately
		action :delete
	end
end