#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_adb48842-9696-4de1-a433-e8f03f58b60f_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-adb48842-9696-4de1-a433-e8f03f58b60f.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-adb48842-9696-4de1-a433-e8f03f58b60f.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['adb48842-9696-4de1-a433-e8f03f58b60f']['InstallationDir']}/service-adb48842-9696-4de1-a433-e8f03f58b60f.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-adb48842-9696-4de1-a433-e8f03f58b60f.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['adb48842-9696-4de1-a433-e8f03f58b60f']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['adb48842-9696-4de1-a433-e8f03f58b60f']['InstallationDir']}/service-adb48842-9696-4de1-a433-e8f03f58b60f.jar" do
  		source "#{node['CHOReOSData']['serviceData']['adb48842-9696-4de1-a433-e8f03f58b60f']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_adb48842-9696-4de1-a433-e8f03f58b60f_jar]"
		notifies :start, "service[service_adb48842-9696-4de1-a433-e8f03f58b60f_jar]"
	end
end

if node['CHOReOSData']['serviceData']['adb48842-9696-4de1-a433-e8f03f58b60f']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['adb48842-9696-4de1-a433-e8f03f58b60f']['InstallationDir']}/service-adb48842-9696-4de1-a433-e8f03f58b60f.jar" do
		notifies :stop, "service[service_adb48842-9696-4de1-a433-e8f03f58b60f_jar]", :immediately
		#notifies :disable, "service[service_adb48842-9696-4de1-a433-e8f03f58b60f_jar]", :immediately
		action :delete
	end
end