#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_b43513e1-b70f-4e61-b660-215cc586c427_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/serviceb43513e1-b70f-4e61-b660-215cc586c427Deploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['b43513e1-b70f-4e61-b660-215cc586c427']['installationDir']}/serviceb43513e1-b70f-4e61-b660-215cc586c427Deploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/serviceb43513e1-b70f-4e61-b660-215cc586c427Deploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['b43513e1-b70f-4e61-b660-215cc586c427']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['b43513e1-b70f-4e61-b660-215cc586c427']['InstallationDir']}/serviceb43513e1-b70f-4e61-b660-215cc586c427Deploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['b43513e1-b70f-4e61-b660-215cc586c427']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_b43513e1-b70f-4e61-b660-215cc586c427_jar]"
		notifies :start, "service[service_b43513e1-b70f-4e61-b660-215cc586c427_jar]"
	end
end

if node['CHOReOSData']['serviceData']['b43513e1-b70f-4e61-b660-215cc586c427']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['b43513e1-b70f-4e61-b660-215cc586c427']['InstallationDir']}/serviceb43513e1-b70f-4e61-b660-215cc586c427Deploy.jar" do
		notifies :stop, "service[service_b43513e1-b70f-4e61-b660-215cc586c427_jar]", :immediately
		#notifies :disable, "service[service_b43513e1-b70f-4e61-b660-215cc586c427_jar]", :immediately
		action :delete
	end
end