#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_b5725d62-43e0-4a68-a362-56f287eb76d0_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-b5725d62-43e0-4a68-a362-56f287eb76d0.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-b5725d62-43e0-4a68-a362-56f287eb76d0.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['b5725d62-43e0-4a68-a362-56f287eb76d0']['InstallationDir']}/service-b5725d62-43e0-4a68-a362-56f287eb76d0.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-b5725d62-43e0-4a68-a362-56f287eb76d0.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['b5725d62-43e0-4a68-a362-56f287eb76d0']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['b5725d62-43e0-4a68-a362-56f287eb76d0']['InstallationDir']}/service-b5725d62-43e0-4a68-a362-56f287eb76d0.jar" do
  		source "#{node['CHOReOSData']['serviceData']['b5725d62-43e0-4a68-a362-56f287eb76d0']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_b5725d62-43e0-4a68-a362-56f287eb76d0_jar]"
		notifies :start, "service[service_b5725d62-43e0-4a68-a362-56f287eb76d0_jar]"
	end
end

if node['CHOReOSData']['serviceData']['b5725d62-43e0-4a68-a362-56f287eb76d0']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['b5725d62-43e0-4a68-a362-56f287eb76d0']['InstallationDir']}/service-b5725d62-43e0-4a68-a362-56f287eb76d0.jar" do
		notifies :stop, "service[service_b5725d62-43e0-4a68-a362-56f287eb76d0_jar]", :immediately
		#notifies :disable, "service[service_b5725d62-43e0-4a68-a362-56f287eb76d0_jar]", :immediately
		action :delete
	end
end