#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_bbc98075-f264-48df-9aa0-ec362726d8b4_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-bbc98075-f264-48df-9aa0-ec362726d8b4.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-bbc98075-f264-48df-9aa0-ec362726d8b4.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['bbc98075-f264-48df-9aa0-ec362726d8b4']['InstallationDir']}/service-bbc98075-f264-48df-9aa0-ec362726d8b4.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-bbc98075-f264-48df-9aa0-ec362726d8b4.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['bbc98075-f264-48df-9aa0-ec362726d8b4']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['bbc98075-f264-48df-9aa0-ec362726d8b4']['InstallationDir']}/service-bbc98075-f264-48df-9aa0-ec362726d8b4.jar" do
  		source "#{node['CHOReOSData']['serviceData']['bbc98075-f264-48df-9aa0-ec362726d8b4']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_bbc98075-f264-48df-9aa0-ec362726d8b4_jar]"
		notifies :start, "service[service_bbc98075-f264-48df-9aa0-ec362726d8b4_jar]"
	end
end

if node['CHOReOSData']['serviceData']['bbc98075-f264-48df-9aa0-ec362726d8b4']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['bbc98075-f264-48df-9aa0-ec362726d8b4']['InstallationDir']}/service-bbc98075-f264-48df-9aa0-ec362726d8b4.jar" do
		notifies :stop, "service[service_bbc98075-f264-48df-9aa0-ec362726d8b4_jar]", :immediately
		#notifies :disable, "service[service_bbc98075-f264-48df-9aa0-ec362726d8b4_jar]", :immediately
		action :delete
	end
end