#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_c1bac442-746c-4232-8a68-de6a3f4f6f0e_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-c1bac442-746c-4232-8a68-de6a3f4f6f0e.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-c1bac442-746c-4232-8a68-de6a3f4f6f0e.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['c1bac442-746c-4232-8a68-de6a3f4f6f0e']['InstallationDir']}/service-c1bac442-746c-4232-8a68-de6a3f4f6f0e.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-c1bac442-746c-4232-8a68-de6a3f4f6f0e.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['c1bac442-746c-4232-8a68-de6a3f4f6f0e']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['c1bac442-746c-4232-8a68-de6a3f4f6f0e']['InstallationDir']}/service-c1bac442-746c-4232-8a68-de6a3f4f6f0e.jar" do
  		source "#{node['CHOReOSData']['serviceData']['c1bac442-746c-4232-8a68-de6a3f4f6f0e']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_c1bac442-746c-4232-8a68-de6a3f4f6f0e_jar]"
		notifies :start, "service[service_c1bac442-746c-4232-8a68-de6a3f4f6f0e_jar]"
	end
end

if node['CHOReOSData']['serviceData']['c1bac442-746c-4232-8a68-de6a3f4f6f0e']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['c1bac442-746c-4232-8a68-de6a3f4f6f0e']['InstallationDir']}/service-c1bac442-746c-4232-8a68-de6a3f4f6f0e.jar" do
		notifies :stop, "service[service_c1bac442-746c-4232-8a68-de6a3f4f6f0e_jar]", :immediately
		#notifies :disable, "service[service_c1bac442-746c-4232-8a68-de6a3f4f6f0e_jar]", :immediately
		action :delete
	end
end