#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_c9abdd8d-ae9c-4be7-92c5-a85cc5859772_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-c9abdd8d-ae9c-4be7-92c5-a85cc5859772.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-c9abdd8d-ae9c-4be7-92c5-a85cc5859772.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['c9abdd8d-ae9c-4be7-92c5-a85cc5859772']['InstallationDir']}/service-c9abdd8d-ae9c-4be7-92c5-a85cc5859772.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-c9abdd8d-ae9c-4be7-92c5-a85cc5859772.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['c9abdd8d-ae9c-4be7-92c5-a85cc5859772']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['c9abdd8d-ae9c-4be7-92c5-a85cc5859772']['InstallationDir']}/service-c9abdd8d-ae9c-4be7-92c5-a85cc5859772.jar" do
  		source "#{node['CHOReOSData']['serviceData']['c9abdd8d-ae9c-4be7-92c5-a85cc5859772']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_c9abdd8d-ae9c-4be7-92c5-a85cc5859772_jar]"
		notifies :start, "service[service_c9abdd8d-ae9c-4be7-92c5-a85cc5859772_jar]"
	end
end

if node['CHOReOSData']['serviceData']['c9abdd8d-ae9c-4be7-92c5-a85cc5859772']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['c9abdd8d-ae9c-4be7-92c5-a85cc5859772']['InstallationDir']}/service-c9abdd8d-ae9c-4be7-92c5-a85cc5859772.jar" do
		notifies :stop, "service[service_c9abdd8d-ae9c-4be7-92c5-a85cc5859772_jar]", :immediately
		#notifies :disable, "service[service_c9abdd8d-ae9c-4be7-92c5-a85cc5859772_jar]", :immediately
		action :delete
	end
end