#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_ce50857d-02bc-4784-8379-e283ff5fdd87_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-ce50857d-02bc-4784-8379-e283ff5fdd87.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-ce50857d-02bc-4784-8379-e283ff5fdd87.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['ce50857d-02bc-4784-8379-e283ff5fdd87']['InstallationDir']}/service-ce50857d-02bc-4784-8379-e283ff5fdd87.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-ce50857d-02bc-4784-8379-e283ff5fdd87.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['ce50857d-02bc-4784-8379-e283ff5fdd87']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['ce50857d-02bc-4784-8379-e283ff5fdd87']['InstallationDir']}/service-ce50857d-02bc-4784-8379-e283ff5fdd87.jar" do
  		source "#{node['CHOReOSData']['serviceData']['ce50857d-02bc-4784-8379-e283ff5fdd87']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_ce50857d-02bc-4784-8379-e283ff5fdd87_jar]"
		notifies :start, "service[service_ce50857d-02bc-4784-8379-e283ff5fdd87_jar]"
	end
end

if node['CHOReOSData']['serviceData']['ce50857d-02bc-4784-8379-e283ff5fdd87']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['ce50857d-02bc-4784-8379-e283ff5fdd87']['InstallationDir']}/service-ce50857d-02bc-4784-8379-e283ff5fdd87.jar" do
		notifies :stop, "service[service_ce50857d-02bc-4784-8379-e283ff5fdd87_jar]", :immediately
		#notifies :disable, "service[service_ce50857d-02bc-4784-8379-e283ff5fdd87_jar]", :immediately
		action :delete
	end
end