#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_d053097b-9bb9-4e65-a7a6-e7c7d972010b_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-d053097b-9bb9-4e65-a7a6-e7c7d972010b.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-d053097b-9bb9-4e65-a7a6-e7c7d972010b.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['d053097b-9bb9-4e65-a7a6-e7c7d972010b']['InstallationDir']}/service-d053097b-9bb9-4e65-a7a6-e7c7d972010b.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-d053097b-9bb9-4e65-a7a6-e7c7d972010b.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['d053097b-9bb9-4e65-a7a6-e7c7d972010b']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['d053097b-9bb9-4e65-a7a6-e7c7d972010b']['InstallationDir']}/service-d053097b-9bb9-4e65-a7a6-e7c7d972010b.jar" do
  		source "#{node['CHOReOSData']['serviceData']['d053097b-9bb9-4e65-a7a6-e7c7d972010b']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_d053097b-9bb9-4e65-a7a6-e7c7d972010b_jar]"
		notifies :start, "service[service_d053097b-9bb9-4e65-a7a6-e7c7d972010b_jar]"
	end
end

if node['CHOReOSData']['serviceData']['d053097b-9bb9-4e65-a7a6-e7c7d972010b']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['d053097b-9bb9-4e65-a7a6-e7c7d972010b']['InstallationDir']}/service-d053097b-9bb9-4e65-a7a6-e7c7d972010b.jar" do
		notifies :stop, "service[service_d053097b-9bb9-4e65-a7a6-e7c7d972010b_jar]", :immediately
		#notifies :disable, "service[service_d053097b-9bb9-4e65-a7a6-e7c7d972010b_jar]", :immediately
		action :delete
	end
end