#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_d2e966b6-feff-4f29-8341-d5fa5f72a1b2_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/serviced2e966b6-feff-4f29-8341-d5fa5f72a1b2Deploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['d2e966b6-feff-4f29-8341-d5fa5f72a1b2']['installationDir']}/serviced2e966b6-feff-4f29-8341-d5fa5f72a1b2Deploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/serviced2e966b6-feff-4f29-8341-d5fa5f72a1b2Deploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['d2e966b6-feff-4f29-8341-d5fa5f72a1b2']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['d2e966b6-feff-4f29-8341-d5fa5f72a1b2']['InstallationDir']}/serviced2e966b6-feff-4f29-8341-d5fa5f72a1b2Deploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['d2e966b6-feff-4f29-8341-d5fa5f72a1b2']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_d2e966b6-feff-4f29-8341-d5fa5f72a1b2_jar]"
		notifies :start, "service[service_d2e966b6-feff-4f29-8341-d5fa5f72a1b2_jar]"
	end
end

if node['CHOReOSData']['serviceData']['d2e966b6-feff-4f29-8341-d5fa5f72a1b2']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['d2e966b6-feff-4f29-8341-d5fa5f72a1b2']['InstallationDir']}/serviced2e966b6-feff-4f29-8341-d5fa5f72a1b2Deploy.jar" do
		notifies :stop, "service[service_d2e966b6-feff-4f29-8341-d5fa5f72a1b2_jar]", :immediately
		#notifies :disable, "service[service_d2e966b6-feff-4f29-8341-d5fa5f72a1b2_jar]", :immediately
		action :delete
	end
end