#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_d57666ab-200e-4bad-b6b4-53dc9ba8b671_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-d57666ab-200e-4bad-b6b4-53dc9ba8b671.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-d57666ab-200e-4bad-b6b4-53dc9ba8b671.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['d57666ab-200e-4bad-b6b4-53dc9ba8b671']['InstallationDir']}/service-d57666ab-200e-4bad-b6b4-53dc9ba8b671.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-d57666ab-200e-4bad-b6b4-53dc9ba8b671.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['d57666ab-200e-4bad-b6b4-53dc9ba8b671']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['d57666ab-200e-4bad-b6b4-53dc9ba8b671']['InstallationDir']}/service-d57666ab-200e-4bad-b6b4-53dc9ba8b671.jar" do
  		source "#{node['CHOReOSData']['serviceData']['d57666ab-200e-4bad-b6b4-53dc9ba8b671']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_d57666ab-200e-4bad-b6b4-53dc9ba8b671_jar]"
		notifies :start, "service[service_d57666ab-200e-4bad-b6b4-53dc9ba8b671_jar]"
	end
end

if node['CHOReOSData']['serviceData']['d57666ab-200e-4bad-b6b4-53dc9ba8b671']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['d57666ab-200e-4bad-b6b4-53dc9ba8b671']['InstallationDir']}/service-d57666ab-200e-4bad-b6b4-53dc9ba8b671.jar" do
		notifies :stop, "service[service_d57666ab-200e-4bad-b6b4-53dc9ba8b671_jar]", :immediately
		#notifies :disable, "service[service_d57666ab-200e-4bad-b6b4-53dc9ba8b671_jar]", :immediately
		action :delete
	end
end