#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_d5abe41b-f94e-4771-8a64-9fa08f165c9f_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-d5abe41b-f94e-4771-8a64-9fa08f165c9f.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-d5abe41b-f94e-4771-8a64-9fa08f165c9f.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['d5abe41b-f94e-4771-8a64-9fa08f165c9f']['InstallationDir']}/service-d5abe41b-f94e-4771-8a64-9fa08f165c9f.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-d5abe41b-f94e-4771-8a64-9fa08f165c9f.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['d5abe41b-f94e-4771-8a64-9fa08f165c9f']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['d5abe41b-f94e-4771-8a64-9fa08f165c9f']['InstallationDir']}/service-d5abe41b-f94e-4771-8a64-9fa08f165c9f.jar" do
  		source "#{node['CHOReOSData']['serviceData']['d5abe41b-f94e-4771-8a64-9fa08f165c9f']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_d5abe41b-f94e-4771-8a64-9fa08f165c9f_jar]"
		notifies :start, "service[service_d5abe41b-f94e-4771-8a64-9fa08f165c9f_jar]"
	end
end

if node['CHOReOSData']['serviceData']['d5abe41b-f94e-4771-8a64-9fa08f165c9f']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['d5abe41b-f94e-4771-8a64-9fa08f165c9f']['InstallationDir']}/service-d5abe41b-f94e-4771-8a64-9fa08f165c9f.jar" do
		notifies :stop, "service[service_d5abe41b-f94e-4771-8a64-9fa08f165c9f_jar]", :immediately
		#notifies :disable, "service[service_d5abe41b-f94e-4771-8a64-9fa08f165c9f_jar]", :immediately
		action :delete
	end
end