#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_dc12c5cf-a30b-4845-bf5a-3d3ea4b3a985_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-dc12c5cf-a30b-4845-bf5a-3d3ea4b3a985.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-dc12c5cf-a30b-4845-bf5a-3d3ea4b3a985.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['dc12c5cf-a30b-4845-bf5a-3d3ea4b3a985']['InstallationDir']}/service-dc12c5cf-a30b-4845-bf5a-3d3ea4b3a985.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-dc12c5cf-a30b-4845-bf5a-3d3ea4b3a985.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['dc12c5cf-a30b-4845-bf5a-3d3ea4b3a985']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['dc12c5cf-a30b-4845-bf5a-3d3ea4b3a985']['InstallationDir']}/service-dc12c5cf-a30b-4845-bf5a-3d3ea4b3a985.jar" do
  		source "#{node['CHOReOSData']['serviceData']['dc12c5cf-a30b-4845-bf5a-3d3ea4b3a985']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_dc12c5cf-a30b-4845-bf5a-3d3ea4b3a985_jar]"
		notifies :start, "service[service_dc12c5cf-a30b-4845-bf5a-3d3ea4b3a985_jar]"
	end
end

if node['CHOReOSData']['serviceData']['dc12c5cf-a30b-4845-bf5a-3d3ea4b3a985']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['dc12c5cf-a30b-4845-bf5a-3d3ea4b3a985']['InstallationDir']}/service-dc12c5cf-a30b-4845-bf5a-3d3ea4b3a985.jar" do
		notifies :stop, "service[service_dc12c5cf-a30b-4845-bf5a-3d3ea4b3a985_jar]", :immediately
		#notifies :disable, "service[service_dc12c5cf-a30b-4845-bf5a-3d3ea4b3a985_jar]", :immediately
		action :delete
	end
end