#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_de4a71fb-0037-486e-b195-744b832876fc_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-de4a71fb-0037-486e-b195-744b832876fc.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-de4a71fb-0037-486e-b195-744b832876fc.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['de4a71fb-0037-486e-b195-744b832876fc']['InstallationDir']}/service-de4a71fb-0037-486e-b195-744b832876fc.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-de4a71fb-0037-486e-b195-744b832876fc.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['de4a71fb-0037-486e-b195-744b832876fc']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['de4a71fb-0037-486e-b195-744b832876fc']['InstallationDir']}/service-de4a71fb-0037-486e-b195-744b832876fc.jar" do
  		source "#{node['CHOReOSData']['serviceData']['de4a71fb-0037-486e-b195-744b832876fc']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_de4a71fb-0037-486e-b195-744b832876fc_jar]"
		notifies :start, "service[service_de4a71fb-0037-486e-b195-744b832876fc_jar]"
	end
end

if node['CHOReOSData']['serviceData']['de4a71fb-0037-486e-b195-744b832876fc']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['de4a71fb-0037-486e-b195-744b832876fc']['InstallationDir']}/service-de4a71fb-0037-486e-b195-744b832876fc.jar" do
		notifies :stop, "service[service_de4a71fb-0037-486e-b195-744b832876fc_jar]", :immediately
		#notifies :disable, "service[service_de4a71fb-0037-486e-b195-744b832876fc_jar]", :immediately
		action :delete
	end
end