#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_de97d9ba-4240-4a1f-9173-6ecf2db97fa1_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-de97d9ba-4240-4a1f-9173-6ecf2db97fa1.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-de97d9ba-4240-4a1f-9173-6ecf2db97fa1.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['de97d9ba-4240-4a1f-9173-6ecf2db97fa1']['InstallationDir']}/service-de97d9ba-4240-4a1f-9173-6ecf2db97fa1.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-de97d9ba-4240-4a1f-9173-6ecf2db97fa1.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['de97d9ba-4240-4a1f-9173-6ecf2db97fa1']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['de97d9ba-4240-4a1f-9173-6ecf2db97fa1']['InstallationDir']}/service-de97d9ba-4240-4a1f-9173-6ecf2db97fa1.jar" do
  		source "#{node['CHOReOSData']['serviceData']['de97d9ba-4240-4a1f-9173-6ecf2db97fa1']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_de97d9ba-4240-4a1f-9173-6ecf2db97fa1_jar]"
		notifies :start, "service[service_de97d9ba-4240-4a1f-9173-6ecf2db97fa1_jar]"
	end
end

if node['CHOReOSData']['serviceData']['de97d9ba-4240-4a1f-9173-6ecf2db97fa1']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['de97d9ba-4240-4a1f-9173-6ecf2db97fa1']['InstallationDir']}/service-de97d9ba-4240-4a1f-9173-6ecf2db97fa1.jar" do
		notifies :stop, "service[service_de97d9ba-4240-4a1f-9173-6ecf2db97fa1_jar]", :immediately
		#notifies :disable, "service[service_de97d9ba-4240-4a1f-9173-6ecf2db97fa1_jar]", :immediately
		action :delete
	end
end