#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_e2abccfd-ee5d-4382-bfd0-ec8b38594f1a_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-e2abccfd-ee5d-4382-bfd0-ec8b38594f1a.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-e2abccfd-ee5d-4382-bfd0-ec8b38594f1a.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['e2abccfd-ee5d-4382-bfd0-ec8b38594f1a']['InstallationDir']}/service-e2abccfd-ee5d-4382-bfd0-ec8b38594f1a.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-e2abccfd-ee5d-4382-bfd0-ec8b38594f1a.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['e2abccfd-ee5d-4382-bfd0-ec8b38594f1a']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['e2abccfd-ee5d-4382-bfd0-ec8b38594f1a']['InstallationDir']}/service-e2abccfd-ee5d-4382-bfd0-ec8b38594f1a.jar" do
  		source "#{node['CHOReOSData']['serviceData']['e2abccfd-ee5d-4382-bfd0-ec8b38594f1a']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_e2abccfd-ee5d-4382-bfd0-ec8b38594f1a_jar]"
		notifies :start, "service[service_e2abccfd-ee5d-4382-bfd0-ec8b38594f1a_jar]"
	end
end

if node['CHOReOSData']['serviceData']['e2abccfd-ee5d-4382-bfd0-ec8b38594f1a']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['e2abccfd-ee5d-4382-bfd0-ec8b38594f1a']['InstallationDir']}/service-e2abccfd-ee5d-4382-bfd0-ec8b38594f1a.jar" do
		notifies :stop, "service[service_e2abccfd-ee5d-4382-bfd0-ec8b38594f1a_jar]", :immediately
		#notifies :disable, "service[service_e2abccfd-ee5d-4382-bfd0-ec8b38594f1a_jar]", :immediately
		action :delete
	end
end