#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_e2e2ccfc-7228-4cb4-8330-43248bfc522b_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-e2e2ccfc-7228-4cb4-8330-43248bfc522b.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-e2e2ccfc-7228-4cb4-8330-43248bfc522b.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['e2e2ccfc-7228-4cb4-8330-43248bfc522b']['InstallationDir']}/service-e2e2ccfc-7228-4cb4-8330-43248bfc522b.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-e2e2ccfc-7228-4cb4-8330-43248bfc522b.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['e2e2ccfc-7228-4cb4-8330-43248bfc522b']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['e2e2ccfc-7228-4cb4-8330-43248bfc522b']['InstallationDir']}/service-e2e2ccfc-7228-4cb4-8330-43248bfc522b.jar" do
  		source "#{node['CHOReOSData']['serviceData']['e2e2ccfc-7228-4cb4-8330-43248bfc522b']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_e2e2ccfc-7228-4cb4-8330-43248bfc522b_jar]"
		notifies :start, "service[service_e2e2ccfc-7228-4cb4-8330-43248bfc522b_jar]"
	end
end

if node['CHOReOSData']['serviceData']['e2e2ccfc-7228-4cb4-8330-43248bfc522b']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['e2e2ccfc-7228-4cb4-8330-43248bfc522b']['InstallationDir']}/service-e2e2ccfc-7228-4cb4-8330-43248bfc522b.jar" do
		notifies :stop, "service[service_e2e2ccfc-7228-4cb4-8330-43248bfc522b_jar]", :immediately
		#notifies :disable, "service[service_e2e2ccfc-7228-4cb4-8330-43248bfc522b_jar]", :immediately
		action :delete
	end
end