#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_ead4ee56-6f16-4a5e-b651-e497ff31a376_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-ead4ee56-6f16-4a5e-b651-e497ff31a376.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-ead4ee56-6f16-4a5e-b651-e497ff31a376.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['ead4ee56-6f16-4a5e-b651-e497ff31a376']['InstallationDir']}/service-ead4ee56-6f16-4a5e-b651-e497ff31a376.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-ead4ee56-6f16-4a5e-b651-e497ff31a376.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['ead4ee56-6f16-4a5e-b651-e497ff31a376']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['ead4ee56-6f16-4a5e-b651-e497ff31a376']['InstallationDir']}/service-ead4ee56-6f16-4a5e-b651-e497ff31a376.jar" do
  		source "#{node['CHOReOSData']['serviceData']['ead4ee56-6f16-4a5e-b651-e497ff31a376']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_ead4ee56-6f16-4a5e-b651-e497ff31a376_jar]"
		notifies :start, "service[service_ead4ee56-6f16-4a5e-b651-e497ff31a376_jar]"
	end
end

if node['CHOReOSData']['serviceData']['ead4ee56-6f16-4a5e-b651-e497ff31a376']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['ead4ee56-6f16-4a5e-b651-e497ff31a376']['InstallationDir']}/service-ead4ee56-6f16-4a5e-b651-e497ff31a376.jar" do
		notifies :stop, "service[service_ead4ee56-6f16-4a5e-b651-e497ff31a376_jar]", :immediately
		#notifies :disable, "service[service_ead4ee56-6f16-4a5e-b651-e497ff31a376_jar]", :immediately
		action :delete
	end
end